% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TasicBrainData.R
\name{TasicBrainData}
\alias{TasicBrainData}
\title{Obtain the Tasic brain data}
\usage{
TasicBrainData(ensembl = FALSE, location = TRUE, legacy = FALSE)
}
\arguments{
\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object with a single matrix of read counts.
}
\description{
Obtain the mouse brain single-cell RNA-seq data from Tasic et al. (2015).
}
\details{
Column metadata is provided in the same form as supplied in GSE71585.
This contains information such as the reporter gene expressed in each cell, the mouse line, dissection type and so on.

Count data for ERCC spike-ins are stored in the \code{"ERCC"} entry of the \code{\link[SingleCellExperiment]{altExps}}.
Note that some of the spike-in rows have \code{NA} observations for some (but not all) cells.

The last 9 columns (containing \code{_CTX_} in their names) correspond to no-cell control libraries.

If \code{ensembl=TRUE}, the gene symbols are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link[SummarizedExperiment]{rowRanges}} of the output.
Note that this is only performed if \code{ensembl=TRUE}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/tasic-brain}.
}
\examples{
sce <- TasicBrainData()

}
\references{
Tasic A et al. (2016). 
Adult mouse cortical cell taxonomy revealed by single cell transcriptomics.
\emph{Nat. Neurosci.} 19(2), 335-46.
}
\author{
Aaron Lun
}
