% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessMSigDB.R
\name{getMsigdb}
\alias{getMsigdb}
\title{Retrieve MSigDB data hosted on the hub}
\usage{
getMsigdb(
  org = c("hs", "mm"),
  id = c("SYM", "EZID"),
  version = getMsigdbVersions()
)
}
\arguments{
\item{org}{a character, representing the organism whose signature database
needs to be retrieved ("hs" for human and "mm" for mouse).}

\item{id}{a character, representing the ID type to use ("SYM" for gene
symbols and "EZID" for Entrez IDs).}

\item{version}{a character, stating the version of MSigDB to be retrieved
(should be >= 7.2). See \code{getMsigdbVersions()}.}
}
\value{
a GeneSetCollection, containing GeneSet objects from the specified
version of the molecular signatures database (MSigDB).
}
\description{
Download molecular signatures database (MSigDB) hosted on the ExperimentHub
or retrieve pre-downloaded version from cache. This package currently hosts
versions greater than 7.2 for human and mouse with both symbol and Entrez
identifiers.
}
\examples{
gsc = getMsigdb('hs', 'SYM')

}
