\name{segmentFurrowAllStacks}
\alias{segmentFurrowAllStacks}
\title{Cell segmentation of furrow images.}
\description{
Performs segmentation on furrow images using smoothing, adaptive thresholding 
and watershed algorithms.
}
\usage{
segmentFurrowAllStacks(x, L=17, filterSize=3, threshOffset=0.001, closingSize=3, 
    minObjectSize=2^5, maxObjectSize=2^10)
}
\arguments{
    \item{x}{ A 4-dimensional image with dimensions x, y, z, t}
    \item{L}{The characterisitc diameter of a cell in pixels.}
    \item{filterSize}{The size of the filter for gaussian smoothing.}
    \item{threshOffset}{The offset value for the adaptive thresholding algorithm
        that is used to segment cytoplasmic fluorescence signal.}
    \item{closingSize}{The size of the brush that is used to perform a closing 
        operation that smooths the cytoplasmic mask after the adaptive 
        thresholding.}
    \item{minObjectSize}{Determines the threshold below which objects in the 
        cytoplasmic mask are removed.}
    \item{maxObjectSize}{Determines the threshold above which objects in the 
        cytoplasmic mask are removed.}
}
\value{
A list with items.
    \item{x}{A smoothed version of the original image array}
    \item{mask}{Cell masks}
    \item{hs}{An image showing highlighted segmentation of the cell masks}
}
\examples{
if (interactive()) vignette(topic="exampleFurrowSegmentation", package="furrowSeg")
}
\author{Joseph Barry, 2014}
\keyword{furrow}
