\name{plotFeatureEvolution}
\alias{plotFeatureEvolution}
\title{Plot Feature Evolution}
\description{
Plots mean and standard deviation of area and elongation features over time.
}
\usage{
plotFeatureEvolution(x, dt=32.6/60, tMax, myTitle="", cex=1.4, cex.axis=1, 
    px=0.293, mar=c(5.1, 5.1, 4.1, 4.1), legend=TRUE, line=2.5)
}
\arguments{
    \item{x}{A feature table, as supplied by \code{constructFeatureTable}.}
    \item{dt}{Timestep in minutes (numeric).}
    \item{tMax}{Latest time point to plot in minutes (numeric).}
    \item{myTitle}{Plot title (string).}
    \item{cex}{Label size.}
    \item{cex.axis}{See help for \code{\link{par}}.}
    \item{px}{Pixel width in microns.}
    \item{mar}{See help for \code{\link{par}}.}
    \item{legend}{A logical. Should figure legend be displayed or not?}
    \item{line}{Determines placement of right-hand axis label. See help for 
        \code{\link{mtext}}.}
}
\value{Nothing is returned from this function.}
\examples{
if (interactive()) vignette(topic="genPaperFigures", package="furrowSeg")
}
\author{Joseph Barry, 2014}
\keyword{furrow}
