\name{opto}
\docType{data}
\alias{opto}
\title{Cell Feature Data}
\description{Table containing all cell feature data for optogenetically 
    perturbed samples and controls. Contains the following columns:
    \describe{
        \item{\code{sample}}{Unique sample identifier referring to the .rda 
            object from which the image analysis was loaded.}
        \item{\code{t}}{Integer index of time point.}
        \item{\code{z}}{Integer index of z-stack.}
        \item{\code{x.0.m.cx}}{x position (along anterior-posterior axis) of 
            cell center in number of pixel lengths.}
        \item{\code{x.0.m.cy}}{y position (along dorsal-ventral axis) of cell 
            center in number of pixel lengths.}
        \item{\code{x.0.m.majoraxis}}{Length of major axis of the cell.}
        \item{\code{x.0.m.theta}}{Angle between the major axis of the cell and 
            the anterior-posterior axis of the embryo.}
        \item{\code{x.0.s.area}}{Area of the cell in number of pixels.}
        \item{\code{x.0.s.perimeter}}{Perimeter length of cell in number of 
            pixel lengths.}
        \item{\code{x.0.s.radius.mean}}{Mean radius of cell in number of pixel 
            lengths.}
        \item{\code{x.0.s.radius.max}}{Maximum radius of cell in number of pixel
            lengths.}
        \item{\code{e.x}}{First component of anisotropy vector. Referred to as 
            AP anisotropy in the paper.}
        \item{\code{e.y}}{Second component of anisotropy vector. Referred to as
            DV anisotropy in the paper.}
        \item{\code{dt}}{Time between frames in seconds}
        \item{\code{px}}{Side length of a (square) pixel in microns. Note that 
            the z-stack spacing is longer.}
        \item{\code{condition}}{Factor identifying which experimental condition
            cell is associated with.}
    }
}
\value{A data table.}
\usage{opto}
\examples{
data(opto, package="furrowSeg")
head(opto)
}
\keyword{datasets}
