main.data <- data.frame(
  Title = c(
    "ref_MCA",                            
    "ref_tabula_muris_drop",
    "ref_tabula_muris_facs",
    "ref_mouse.rnaseq",          
    "ref_moca_main",                
    "ref_immgen",                      
    "ref_hema_microarray",    
    "ref_cortex_dev",              
    "ref_pan_indrop",              
    "ref_pan_smartseq2",
    "ref_mouse_atlas"
  ),
  Description = c(
    "Mouse Cell Atlas",
    "Tabula Muris (10X)",
    "Tabula Muris (SmartSeq2)",
    "Mouse RNA-seq from 28 cell types",
    "Mouse Organogenesis Cell Atlas (main cell types)",
    "Mouse sorted immune cells",
    "Human hematopoietic cell microarray",
    "Human cortex development scRNA-seq",
    "Human pancreatic cell scRNA-seq (inDrop)",
    "Human pancreatic cell scRNA-seq (SmartSeq2)",
    "Mouse Atlas scRNA-seq from 321 cell types"
  ),
  RDataPath = file.path("clustifyrdatahub",
                        c("ref_MCA.rda",
                          "ref_tabula_muris_drop.rda",
                          "ref_tabula_muris_facs.rda",
                          "ref_mouse.rnaseq.rda",
                          "ref_moca_main.rda",
                          "ref_immgen.rda",
                          "ref_hema_microarray.rda",
                          "ref_cortex_dev.rda",
                          "ref_pan_indrop.rda",
                          "ref_pan_smartseq2.rda",
                          "ref_mouse_atlas.rda"
                          )),
  BiocVersion="3.12",
  Genome=c(
    "mm10",
    "mm10",
    "mm10",
    "mm10",
    "mm10",
    "mm10",
    "hg38",
    "hg38",
    "hg38",
    "hg38",
    "mm10"
  ),
  SourceType=c(
    "Zip",
    "Zip",
    "Zip",
    "RDA",
    "RDA",
    "RDA",
    "TXT",
    "TSV",
    "RDA",
    "RDA",
    "RDA"
  ),
  SourceUrl=c(
    "https://ndownloader.figshare.com/files/10756795",
    "https://ndownloader.figshare.com/articles/5821263",
    "https://ndownloader.figshare.com/articles/5821263",
    "https://github.com/dviraran/SingleR/tree/master/data",
    "https://oncoscape.v3.sttrcancer.org/atlas.gs.washington.edu.mouse.rna/downloads",
    "https://github.com/dviraran/SingleR/tree/master/data",
    "https://ftp.ncbi.nlm.nih.gov/geo/series/GSE24nnn/GSE24759/matrix/GSE24759_series_matrix.txt.gz",
    "https://cells.ucsc.edu/cortex-dev/exprMatrix.tsv.gz",
    "https://scrnaseq-public-datasets.s3.amazonaws.com/scater-objects/baron-human.rds",
    "https://scrnaseq-public-datasets.s3.amazonaws.com/scater-objects/segerstolpe.rds",
    "https://github.com/rnabioco/scRNA-seq-Cell-Ref-Matrix/blob/master/atlas/musMusculus/MouseAtlas.rda"
  ),
  SourceVersion=c(
    "7",
    "3",
    "3",
    "mouse.rnaseq.rda",
    "1",
    "immgen.rda",
    "1",
    "1",
    "1",
    "1",
    "1"
  ),
  Species=c(
    "Mus musculus",
    "Mus musculus",
    "Mus musculus",
    "Mus musculus",
    "Mus musculus",
    "Mus musculus",
    "Homo sapiens",
    "Homo sapiens",
    "Homo sapiens",
    "Homo sapiens",
    "Mus musculus"
  ),
  TaxonomyId=c(
    "10090",
    "10090",
    "10090",
    "10090",
    "10090",
    "10090",
    "9606",
    "9606",
    "9606",
    "9606",
    "10090"
  ),
  Coordinate_1_based=NA,
  DataProvider=c(
    "figshare",
    "figshare",
    "figshare",
    "GitHub",
    "washington.edu",
    "GitHub",
    "GEO",
    "UCSC",
    "S3",
    "S3",
    "GEO"
  ),
  Maintainer="Rui Fu <raysinensis@gmail.com>",
  RDataClass="data.frame",
  DispatchClass="Rda",
  stringsAsFactors = FALSE
)

write.csv(file="metadata.csv", main.data, row.names=FALSE)
