% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{exampleTENETTADRegions}
\alias{exampleTENETTADRegions}
\title{Example TENET topologically associating domain (TAD) regions}
\source{
{
\url{http://3dgenome.fsm.northwestern.edu/publications.html}
}
}
\usage{
exampleTENETTADRegions(metadata = FALSE)
}
\arguments{
\item{metadata}{If TRUE, retrieve the ExperimentHub metadata instead of the
object itself. Defaults to FALSE.}
}
\value{
A GRanges object with 1,889 ranges and no metadata.
}
\description{
A GenomicRanges dataset with example topologically associating
domains (TADs), used to demonstrate TENET's \code{step7TopGenesTADTables}
function. The TADs are derived from T47D cells (mistakenly labeled as
'T470'), and aligned to the human hg38 genome. They were downloaded from the
3D Genome Browser at \url{http://3dgenome.fsm.northwestern.edu}. \strong{Citation:}
Wang Y, Song F, Zhang B, et al. The 3D Genome Browser: a web-based browser
for visualizing 3D genome organization and long-range chromatin interactions.
Genome Biol. 2018 Oct 4;19(1):151. doi: 10.1186/s13059-018-1519-9. PMID:
30286773; PMCID: PMC6172833.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
exampleTENETTADRegions()
\dontshow{\}) # examplesIf}
}
