% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{exampleTENETPeakRegions}
\alias{exampleTENETPeakRegions}
\title{Example TENET peak regions}
\source{
{
\url{https://www.encodeproject.org/files/ENCFF112JVK/}
}
}
\usage{
exampleTENETPeakRegions(metadata = FALSE)
}
\arguments{
\item{metadata}{If TRUE, retrieve the ExperimentHub metadata instead of the
object itself. Defaults to FALSE.}
}
\value{
A GRanges object with 37,386 ranges and no metadata.
}
\description{
A GenomicRanges dataset with example genomic regions (peaks) of
interest, used to demonstrate TENET's \code{step7TopGenesUserPeakOverlap}
function. The peaks are derived from a ChIP-seq experiment on FOXA1 in MCF-7
cells and aligned to the human hg38 genome. They were downloaded from the
ENCODE portal (file ENCFF112JVK in experiment ENCSR126YEB). \strong{Citation:}
ENCODE Project Consortium; Moore JE, Purcaro MJ, Pratt HE, et al. Expanded
encyclopaedias of DNA elements in the human and mouse genomes. Nature. 2020
Jul;583(7818):699-710. doi: 10.1038/s41586-020-2493-4. Epub 2020 Jul 29.
Erratum in: Nature. 2022 May;605(7909):E3. PMID: 32728249; PMCID: PMC7410828.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
exampleTENETPeakRegions()
\dontshow{\}) # examplesIf}
}
