# PhyloProfileData
[![Bioconductor](https://img.shields.io/badge/available%20at-Bioconductor-orange)](https://bioconductor.org/packages/PhyloProfileData)
<a href="http://bioconductor.org/checkResults/release/data-experiment-LATEST/PhyloProfileData/"><img border="0" src="http://www.bioconductor.org/shields/build/release/data-experiment/PhyloProfileData.svg" title="build results; click for full report"></a>.
[![license: MIT](https://img.shields.io/badge/license-MIT-lightgrey.svg)](https://opensource.org/licenses/MIT)


The PhyloProfileData package provides a collection of datasets to accompany the 
R package [PhyloProfile pakage](https://github.com/BIONF/PhyloProfile) 
([Tran et al. 2018](https://doi.org/10.1093/bioinformatics/bty225)), where they 
are used to illustrate how to run PhyloProfile and analyse its results. Briefly,
it contains the phylogenetic profiles, the fasta sequences and the domain 
annotations for two experimental data sets, including
1. 147 human proteins in the AMPK-TOR pathway across 83 species, and
2. 1011 BUSCO arthropoda ortholog groups across 88 species in the three domains 
of life.

# Installation

```r
if (!requireNamespace("BiocManager"))
    install.packages("BiocManager")
BiocManager::install("PhyloProfileData")
```

# Usage

The data are stored in the 
[ExperimentHub](https://bioconductor.org/packages/release/bioc/html/ExperimentHub.html) 
of [Bioconductor](http://bioconductor.org) and can be accessed using the 
following R commands:

```r
# Load the data of the PhyloProfileData package
library(ExperimentHub)
eh = ExperimentHub()
myData <- query(eh, "PhyloProfileData")
# View the metadata of this data package
myData
```

```
ExperimentHub with 6 records
# snapshotDate(): 2019-05-29 
# $dataprovider: Applied Bioinformatics Dept., Goethe University Frankfurt
# $species: NA
# $rdataclass: data.frame, AAStringSet
# additional mcols(): taxonomyid, genome, description, coordinate_1_based,
#   maintainer, rdatadateadded, preparerclass, tags, rdatapath, sourceurl,
#   sourcetype 
# retrieve records with, e.g., 'object[["EH2544"]]' 

           title                                                                         
  EH2544 | Phylogenetic profiles of human AMPK-TOR pathway                               
  EH2545 | FASTA sequences for proteins in the phylogenetic profiles of human AMPK-TOR...
  EH2546 | Domain annotations for proteins in the phylogenetic profiles of human AMPK-...
  EH2547 | Phylogenetic profiles of BUSCO arthropoda proteins                            
  EH2548 | FASTA sequences for proteins in the phylogenetic profiles of BUSCO arthropo...
  EH2549 | Domain annotations for proteins in the phylogenetic profiles of BUSCO arthr...
```


Each data set contains three files (objects) corresponding for the phylogenetic 
profiles, the FASTA sequences and the protein domain annotations. A particular 
data object can be retrieve using its ID, for example:

```r
# Retrieve FASTA sequences for proteins in the phylogenetic profiles of the 
# human AMPK-TOR pathway
ampkTorFasta <- myData[["EH2545"]]
```

For a detailed description of each data set and the belonging data objects 
please see the vignette PhyloProfileData.

```r
library(PhyloProfileData)
browseVignettes("PhyloProfileData")
```

# Bugs, Comments and Suggests
Any bug reports or comments, suggestionsare highly appreciated. Please [open an 
issue on GitHub](https://github.com/BIONF/PhyloProfileData/issues/new) or be in 
touch [via email](mailto:tran@bio.uni-frankfurt.de).

# Contributors
* [Vinh](https://github.com/trvinh)
* [Hannah](https://github.com/mueli94)

# License
This data package is released under [MIT license](https://github.com/BIONF/PhyloProfile/blob/master/LICENSE).

# How-To Cite
Ngoc-Vinh Tran, Bastian Greshake Tzovaras, Ingo Ebersberger; PhyloProfile: Dynamic visualization and exploration of multi-layered phylogenetic profiles, Bioinformatics, , bty225, https://doi.org/10.1093/bioinformatics/bty225

or use the citation function in R CMD to have it directly in BibTex or LaTeX format
```r
citation("PhyloProfileData")
```

# Contact
Vinh Tran
tran@bio.uni-frankfurt.de
