/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.measures.graph.pairwise.dag.edge_based.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import slib.graph.algo.shortest_path.Dijkstra;
import slib.utils.ex.SLIB_Exception;
import slib.utils.impl.SetUtils;

public class SimDagEdgeUtils {
    public static URI getMSA_pekar_staab(URI root, Map<URI, Double> allSpA, Map<URI, Double> allSpB, Set<URI> ancestors_A, Set<URI> ancestors_B, Dijkstra dijkstra) {
        Set<URI> interSecAncestors = SetUtils.intersection(ancestors_A, ancestors_B);
        HashMap<URI, Double> msaSet = new HashMap<URI, Double>();
        if (!interSecAncestors.isEmpty()) {
            double scoremin = Double.MAX_VALUE;
            for (URI r : interSecAncestors) {
                double sp_root = dijkstra.shortestPath(r, root);
                double score = allSpA.get(r) + allSpB.get(r) + sp_root;
                if (scoremin > score) {
                    scoremin = score;
                    msaSet.clear();
                    msaSet.put(r, sp_root);
                    continue;
                }
                if (scoremin != score) continue;
                msaSet.put(r, sp_root);
            }
        }
        URI msa = root;
        double msalpr = 0.0;
        for (Map.Entry e : msaSet.entrySet()) {
            if (!((Double)e.getValue() > msalpr)) continue;
            msalpr = (Double)e.getValue();
            msa = (URI)e.getKey();
        }
        return msa;
    }

    public static URI searchMSA(Set<URI> interSecAncestors, Map<URI, Integer> maxDepths) throws SLIB_Exception {
        URI msa = null;
        int dMSA = -1;
        for (URI r : interSecAncestors) {
            if (msa != null && maxDepths.get(r) <= dMSA) continue;
            msa = r;
            dMSA = maxDepths.get(r);
        }
        return msa;
    }
}

