/*
 * Decompiled with CFR 0.152.
 */
package slib.graph.algo.accessor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import slib.graph.algo.accessor.InstanceAccessor;

public class InstanceAccessorGen
implements InstanceAccessor {
    Set<URI> instances;
    Map<URI, Set<URI>> mapInstancesClass;

    public InstanceAccessorGen(Set<URI> instances, Map<URI, Set<URI>> mapClassInstances) {
        this.instances = instances;
        this.mapInstancesClass = new HashMap<URI, Set<URI>>();
        for (Map.Entry<URI, Set<URI>> e : mapClassInstances.entrySet()) {
            for (URI i : e.getValue()) {
                if (!instances.contains(i)) {
                    throw new IllegalArgumentException("Error loading Instance Accessor URI " + i + " defined as an instance of class " + e.getKey() + " is not defined as an instance...");
                }
                if (!this.mapInstancesClass.containsKey(i)) {
                    this.mapInstancesClass.put(i, new HashSet());
                }
                this.mapInstancesClass.get(i).add(e.getKey());
            }
        }
    }

    @Override
    public Iterator<URI> getInstancesIt() {
        return this.getInstances().iterator();
    }

    @Override
    public Set<URI> getInstances() {
        return this.instances;
    }

    @Override
    public int getInstanceNb() {
        return this.getInstances().size();
    }

    @Override
    public Iterator<URI> getClassesOfInstanceIt(URI instance) {
        return this.getClassesOfInstance(instance).iterator();
    }

    @Override
    public Set<URI> getClassesOfInstance(URI instance) {
        this.errorIfNotInstance(instance);
        return this.mapInstancesClass.get(instance);
    }

    private void errorIfNotInstance(URI instance) {
        if (!this.instances.contains(instance)) {
            throw new IllegalArgumentException("URI " + instance + " does not refer to an instance in the given instance Accessor");
        }
    }
}

