% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mk_subread_index.R
\name{mk_subread_index}
\alias{mk_subread_index}
\title{Make a Subread index}
\usage{
mk_subread_index(ref_lib, split = 4, mem = 8000, quiet = TRUE)
}
\arguments{
\item{ref_lib}{The name/location of the reference library file, in
(uncompressed) .fasta format.}

\item{split}{The maximum allowed size of the genome file (in GB). If the
\code{ref_lib} file is larger than this, the function will split the
library into multiple parts.}

\item{mem}{The maximum amount of memory (in MB) that can be used by the index
generation process (used by the Rsubread::buildindex function).}

\item{quiet}{Turns off most messages. Default is \code{TRUE}.}
}
\value{
Creates one or more Subread indexes for the supplied reference .fasta
  file. If multiple indexes are created, the libraries will be named the
  \code{ref_lib} basename + "_1", "_2", etc. The function returns the names of the
  folders holding these files.
}
\description{
This function is a wrapper for the \code{Rsubread::buildindex} function. It
will generate one or more Subread indexes from a .fasta file. If the library
is too large (default >4GB) it will automatically be split into multiple
indexes, with _1, _2, etc at the end of the ref_lib basename.
}
\examples{
#### Create a subread index from the example reference library

## Create a temporary directory to store the reference library
ref_temp <- tempfile()
dir.create(ref_temp)
tmp_accession <- system.file("extdata", "example_accessions.sql", package = "MetaScope")

## Download reference genome
out_fasta <- download_refseq('Orthoebolavirus zairense', reference = FALSE,
                             representative = FALSE, out_dir = ref_temp,
                             compress = TRUE, patho_out = FALSE,
                             caching = TRUE, accession_path = tmp_accession)

## Make subread index of reference library
mk_subread_index(out_fasta)
unlink(ref_temp)

}
