% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadPancreasDatasets.R
\name{loadPancreasDatasets}
\alias{loadPancreasDatasets}
\title{Function to load pancreas cancer expression profiles from the Experiment Hub}
\usage{
loadPancreasDatasets(
  removeDuplicates = TRUE,
  quantileCutoff = 0,
  rescale = FALSE,
  minNumberGenes = NA,
  minSampleSize = NA,
  minNumberEvents = NA,
  removeSeqSubset = FALSE,
  keepCommonOnly = FALSE,
  imputeMissing = FALSE
)
}
\arguments{
\item{removeDuplicates}{remove patients with a Spearman correlation greater
than or equal to 0.98 with other patient expression profiles (default TRUE)}

\item{quantileCutoff}{A numeric between 0 and 1 specifying to remove genes with
standard deviation below the required quantile (default 0)}

\item{rescale}{apply centering and scaling to the expression sets (default FALSE)}

\item{minNumberGenes}{an integer specifying to remove expression sets with less genes
than this number (default 0)}

\item{minSampleSize}{an integer specifying the minimum number of patients required in an SE (default 0)}

\item{minNumberEvents}{an integer specifying how man survival events must be in the dataset to keep the dataset
(default 0)}

\item{removeSeqSubset}{currently only removes the ICGSSEQ dataset as it contains the same patients as
the ICGS microarray dataset (default TRUE, currently just ICGSSEQ)}

\item{keepCommonOnly}{remove probes not common to all datasets (default FALSE)}

\item{imputeMissing}{impute missing expression value via knn}
}
\value{
a list with two elements. The First element named SummarizedExperiments
        contains the datasets as Bioconductor SummarizedExperiment objects.
        The second element named duplicates contains a vector with patient IDs for the
        duplicate patients (those with Spearman correlation greater than or equal to
        0.98 with other patient expression profiles).
}
\description{
This function returns pancreas cancer patient cohorts in SummarizedExperiment object
from the hub and a vector of patients from the datasets that are duplicates
}
\examples{
sumExptsAndDuplicates <- loadPancreasDatasets()

}
