% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HarmonizedTCGAData-package.r
\docType{data}
\name{Wall}
\alias{Wall}
\title{Wall}
\format{An object of class \code{list} of length 5.}
\usage{
Wall
}
\description{
Wall contains a list of precomputed affinity (similarity) matrices of 2582 patients.
These matrices were derived from 10382 gene expression, miRNA expression and
DNA methylation data files downloaded from GDC data portal
The file UUIDs can be found in inst/extdata/fileUUIDs.csv
Using these file UUIDs, users can download the original data from
https://portal.gdc.cancer.gov/repository
`Wall` is a complex list and contains lists inside list.
Precisely, Wall is a list (five cancer types) of list (six feature normalization types:
raw.all, raw.sel, log.all, log.sel, vst.sel, normalized) of list (three feature spaces
or views: fpkm, mirna, and methy450) of matrices.
(So Wall contains 90 matrices in total)
The rownames of each matrix is the case_id (i.e., patient id),
and the column names of each matrix is the aliquot IDs (i.e., TCGA barcode,
which contains the case_id as prefix).
}
\examples{
library(ExperimentHub)
eh <- ExperimentHub()
myfiles <- query(eh, "HarmonizedTCGAData")
Wall <- myfiles[[1]]
# Wall <- myfiles[['EH1014']]
names(Wall)
names(Wall[[1]])
names(Wall[[1]][[1]])
dim(Wall[[1]][[1]][[1]])
}
\keyword{datasets}
