% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HarmanData.R
\docType{data}
\name{OLF}
\alias{OLF}
\alias{olf.data}
\alias{olf.info}
\title{Olfactory stem cell study data}
\format{
Two data frames. \code{olf.data} has 33,297 probesets (rows) and 28
biological samples (columns). While \code{olf.info} is a description of the
samples, with two columns:
\describe{
  \item{\code{Treatment}}{the treatment applied}
  \item{\code{Batch}}{batch processing number}
}
}
\usage{
data(OLF)
}
\value{
\code{\link{promise}}
}
\description{
An experiment to gauge the response of human olfactory
neurosphere-derived (hONS) cells established from adult donors to ZnO
nanoparticles. The data comprises six treatment groups plus a control group,
each consisting of four replicates, giving a total number of 28 Affymetrix
HuGene 1.0 ST arrays. The arrays were broken up into four processing batches
of seven arrays each, consisting of one replicate from each of the groups.
Arrays were normalised and background adjusted as a whole using the RMA
procedure in MATLAB.
}
\examples{
data(OLF)
}
\references{
Osmond-McLeod et al. Part Fibre Toxicol. (2013).
doi: 10.1186/1743-8977-10-54
}
