### R code from vignette source 'src/sec13_screenplots.Rnw'

###################################################
### code chunk number 1: screenplots1
###################################################
library("HD2013SGI")

data("Interactions",package="HD2013SGI")

dir.create(file.path("result","Figures"),
           recursive=TRUE,showWarnings=FALSE)


###################################################
### code chunk number 2: screenplots2
###################################################
F = "cell.act.m.majoraxis"
EmptyPlate = rep(NA_real_, 24*16)
names(EmptyPlate) = sprintf("%s%d",rep(LETTERS[1:16],each=24),
                            rep(1:24,times=16))
z = list()
for (Rep in seq_len(dim(Interactions$piscore)[6])) {
  for (Q in seq_len(dim(Interactions$piscore)[3])) {
    for (QD in seq_len(dim(Interactions$piscore)[4])) {
      for (TD in seq_len(dim(Interactions$piscore)[2])) {
        Plate = EmptyPlate
        Plate[Interactions$Anno$target$Well] =
                Interactions$piscore[,TD,Q,QD,F,Rep]
        z[[sprintf("Q%d_td%d_qd%d_r%d",Q,TD,QD,Rep)]] = Plate
      }
    }
  }
}


###################################################
### code chunk number 3: screenplots2
###################################################
pdf(file.path("result","Figures","screenPlot.pdf"),width=6,height=2)


###################################################
### code chunk number 4: screenplots2
###################################################
plotScreen(z[1:2], ncol=2L, na.fill="gray90",
           main="pi-score (cell.act.m.majoraxis)",
           zrange=c(-3,3),do.names=FALSE)


###################################################
### code chunk number 5: screenplots2
###################################################
dev.off()

tiff(file.path("result","Figures","screenPlot.tiff"),width=600,height=200)
plotScreen(z[1:2], ncol=2L, na.fill="gray90",
           main="pi-score (cell.act.m.majoraxis)",
           zrange=c(-3,3),do.names=FALSE)
dev.off()



