### R code from vignette source 'src/sec06_rawDataProcessing.Rnw'

###################################################
### code chunk number 1: RawDataProcessing1
###################################################
library("HD2013SGI")


###################################################
### code chunk number 2: RawDataProcessing2
###################################################
data("datamatrixfull",package="HD2013SGI")
D = datamatrixfull$D
data("TargetAnnotation",package="HD2013SGI")
data("QueryAnnotation",package="HD2013SGI")


###################################################
### code chunk number 3: RawDataProcessing3
###################################################
dir.create(file.path("result","data"),recursive=TRUE,showWarnings=FALSE)
dir.create(file.path("result","Figures"),recursive=TRUE,showWarnings=FALSE)
dir.create(file.path("result","Tables"),recursive=TRUE,showWarnings=FALSE)


###################################################
### code chunk number 4: RawDataProcessing4
###################################################
IndexSAMPLE = which(TargetAnnotation$group == "sample")
IndexCTRL = which(TargetAnnotation$group == "SingleKDctrl")
IndexNEG = which(TargetAnnotation$group == "negctrl")
IndexSAMPLENEG = c(IndexSAMPLE, IndexNEG)


###################################################
### code chunk number 5: RawDataProcessing5
###################################################
colCTRL = rep("gray", nrow(TargetAnnotation))
colCTRL[TargetAnnotation$group == "SingleKDctrl"] = "royalblue"
colCTRL[TargetAnnotation$group == "negctrl"] = "red"


###################################################
### code chunk number 6: TransformationAndNormalization1
###################################################
glog <- function(x,c) {
  log2((x+sqrt(x^2+c^2))/2)
}


###################################################
### code chunk number 7: TransformationAndNormalization1
###################################################
px = seq(-1.5, 9, length.out=200)
trsf = list(
  log = function(x) log(ifelse(x>0, x, NA_real_)),
 glog = function(x, c=1) log( (x+sqrt(x^2+c^2))/2 ))
colores = c("#202020", "RoyalBlue")
pdf(file.path("result","Figures","supplementaryInformation-glog.pdf"),width=4.2,height=4.2)
matplot(px, sapply(trsf, do.call, list(px)), type="l", lty=c(2,1), col=colores,
        lwd=2.5, ylab="f(x)", xlab="x")
legend("bottomright", fill=colores, legend=names(trsf))
dev.off()


###################################################
### code chunk number 8: TransformationAndNormalization2
###################################################
for (i in seq_len(dim(D)[5])) {
  m = quantile(D[,,,,i,],probs=0.03,na.rm=TRUE)
  D[,,,,i,] = glog(D[,,,,i,],m)
}


###################################################
### code chunk number 9: TransformationAndNormalization3
###################################################
M = apply(D,c(2:6),median,na.rm=TRUE)
M2 = apply(M, c(2,4), mean)
M2 = rep(M2, times=8)
dim(M2) = dim(M)[c(2,4,1,3,5)]
M2 = aperm(M2,c(3,1,4,2,5))
M = M - M2
M = rep(M[], each=dim(D)[1])
dim(M) = dim(D)
D = D - M


###################################################
### code chunk number 10: TransformationAndNormalization4
###################################################
for (i in seq_len(dim(D)[5])) {
  D[,,,,i,] = (D[,,,,i,] - median(D[,,,,i,],na.rm=TRUE)) /
                mad(D[,,,,i,],na.rm=TRUE)
}


###################################################
### code chunk number 11: qualityControlFeatures1
###################################################
C = rep(NA_real_,dim(D)[5])
D2 = (D[,1,,1,,] + D[,2,,1,,] + D[,1,,2,,] + D[,2,,2,,]) / 4
for (i in seq_len(dim(D)[5])) {
  C[i] = cor(as.vector(D2[IndexSAMPLE,,i,1]),as.vector(D2[IndexSAMPLE,,i,2]))
}


###################################################
### code chunk number 12: qualityControlFeatures2
###################################################
pdf(file=file.path("result","Figures","QCreproducibilityOfFeatures.pdf"))


###################################################
### code chunk number 13: qualityControlFeatures2
###################################################
plot(sort(C, decreasing=TRUE), pch=20, xlab="features", ylab="correlation", ylim=c(0,1),
     cex.lab=1.75, cex.axis=1.5)
abline(h=0.6)


###################################################
### code chunk number 14: qualityControlFeatures2
###################################################
dev.off()


###################################################
### code chunk number 15: qualityControlFeatures3
###################################################
pdf(file=file.path("result","Figures","QCscatterFeaturesBetweenReplicates.pdf"))


###################################################
### code chunk number 16: qualityControlFeatures3
###################################################
i = "cell.Bact.m.eccentricity"
plot(as.vector(D2[IndexSAMPLE,,i,1]),
     as.vector(D2[IndexSAMPLE,,i,2]),
     pch=20, cex.lab=1.75, cex.axis=1.5,
     xlab="eccentricity replicate 1",
     ylab="eccentricity replicate 2")
cc = cor(as.vector(D2[IndexSAMPLE,,i,1]),
         as.vector(D2[IndexSAMPLE,,i,2]))
text(x=2, y=-4, sprintf("cor = %0.2f",cc), cex=1.75)


###################################################
### code chunk number 17: qualityControlFeatures3
###################################################
dev.off()


###################################################
### code chunk number 18: qualityControlFeatures4
###################################################
I = order(-C)
write.table(data.frame(name=dimnames(D)[[5]][I],cor=C[I]),
        file=file.path("result","Tables","QC_reproducibilityOfFeatures.txt"),
        sep="\t",quote=FALSE,row.names=FALSE)


###################################################
### code chunk number 19: qualityControlFeatures5
###################################################
I = which(C >= 0.6)
D = D[,,,,I,,drop=FALSE]
dim(D)


###################################################
### code chunk number 20: qualityControlsiRNA2
###################################################
D1 = (D[,,,1,,1] + D[,,,1,,2] + D[,,,2,,1] + D[,,,2,,2])/4
Cdesign1 = rep(NA_real_,dim(D)[1])
for (k in seq_len(dim(D)[5])) {
  for (i in seq_len(dim(D)[1])) {
    Cdesign1[i] = cor(as.vector(D1[i,1,,k]),as.vector(D1[i,2,,k]))
  }
  if ( k == 1) {
    Cdesign1all = Cdesign1
  } else {
    Cdesign1all = Cdesign1all + Cdesign1
  }
}
Cdesign1all = Cdesign1all / dim(D)[5]


###################################################
### code chunk number 21: qualityControlsiRNA3
###################################################
pdf(file.path("result","Figures","QCreproducibilityOfTargetsiRNA.pdf"))


###################################################
### code chunk number 22: qualityControlsiRNA3
###################################################
plot(sort(Cdesign1all[IndexSAMPLE], decreasing=TRUE),
     pch=20, cex.lab=1.75, cex.axis=1.5, ylim=c(0,1),
     xlab="target genes",ylab="correlation")
abline(h=0.7)


###################################################
### code chunk number 23: qualityControlsiRNA3
###################################################
dev.off()


###################################################
### code chunk number 24: qualityControlsiRNA4
###################################################
pdf(file.path("result","Figures","QCreproducibilityOfTargetsiRNAexample.pdf"),width=2,height=4)
par(xpd=NA,mar=c(6, 4, 2, 2) + 0.1)


###################################################
### code chunk number 25: qualityControlsiRNA4
###################################################
f = "cell.Bact.m.eccentricity"
D1 = D[ TargetAnnotation$Symbol == "CHAF1A",,QueryAnnotation$Symbol == "DPF2",1,f,]
bp = barplot(apply(D1,1,mean),ylab="Cell eccentricity",
        names.arg=c("CHAF1A #1\nDPF2 #1","CHAF1A #2\nDPF2 #1"),las=2)
points(bp,D1[,1])
points(bp,D1[,2])


###################################################
### code chunk number 26: qualityControlsiRNA4
###################################################
dev.off()


###################################################
### code chunk number 27: qualityControlsiRNA4
###################################################
I = IndexSAMPLE[Cdesign1all[IndexSAMPLE] >= 0.7]
I = c(I, IndexNEG)
D = D[I,,,,,,drop=FALSE]
TargetAnnotation = TargetAnnotation[I,]
dim(D)


###################################################
### code chunk number 28: featureSelection1
###################################################
D1 = (D[,1,,1,,] + D[,1,,2,,] + D[,2,,1,,] + D[,2,,2,,]) / 4
D1 = D1[TargetAnnotation$group == "sample",,,]


###################################################
### code chunk number 29: featureSelection2
###################################################
dim(D1) = c(prod(dim(D1)[1:2]),dim(D1)[3:4])
D1 = aperm(D1,c(1,3,2))
set.seed(5830458)
Sample = sample(seq_len(dim(D1)[1]), 3000)
subSampleForStabilitySelection = list(D = D1[Sample,,],
                                      Sample = Sample,
                                      phenotype = dimnames(D)[[5]])


###################################################
### code chunk number 30: featureSelection3
###################################################
stabilitySelection = HD2013SGIselectByStability(subSampleForStabilitySelection,
                                       preselect = c("count"),
                                       Rdim = 25, verbose = TRUE)


###################################################
### code chunk number 31: featureSelection4
###################################################
Sel = (stabilitySelection$ratioPositive >= 0.5)
sum(Sel)


###################################################
### code chunk number 32: featureSelection5
###################################################
col = brewer.pal(3,"Pastel1")[1:2]
pdf(file.path("result","Figures","FeatureSelectionInformationgain.pdf"))
par(mar=c(13,4,1,1))


###################################################
### code chunk number 33: featureSelection5
###################################################
barplot(stabilitySelection$correlation,
        names.arg=HD2013SGI:::humanReadableNames[stabilitySelection$selected],
        col=ifelse(Sel, col[2], col[1]),
        ylim=c(0,1), las=2, ylab="information gain")


###################################################
### code chunk number 34: featureSelection5
###################################################
dev.off()


###################################################
### code chunk number 35: featureSelection6
###################################################
pdf(file.path("result","Figures","FeatureSelectionRatioPositive.pdf"))
par(mar=c(13,4,1,1))


###################################################
### code chunk number 36: featureSelection6
###################################################
barplot(stabilitySelection$ratioPositive-0.5,
        names.arg=HD2013SGI:::humanReadableNames[stabilitySelection$selected],
        offset=0.5,col=ifelse(Sel, col[2], col[1]),ylim=c(0,1),
        las=2,ylab="fraction positive correlated")


###################################################
### code chunk number 37: featureSelection6
###################################################
dev.off()


###################################################
### code chunk number 38: featureSelection7
###################################################
save(stabilitySelection, file=file.path("result","data",
                                        "stabilitySelection.rda"))
D = D[,,,,stabilitySelection$selected[Sel],,drop=FALSE]
dimnames(D)[[1]] = TargetAnnotation$Symbol
dimnames(D)[[3]] = QueryAnnotation$Symbol
dim(D)


###################################################
### code chunk number 39: featureSelection8
###################################################
datamatrix = list(D=D, Anno = list(target = TargetAnnotation,
                                   query = QueryAnnotation,
                                   phenotype=dimnames(D)[[5]]))
save(datamatrix, file=file.path("result","data","datamatrix.rda"))


###################################################
### code chunk number 40: pairwiseInteractionScores1
###################################################
D = datamatrix$D
pimatrix = datamatrix
pimatrix$D[] = NA_real_
mainEffects = list(target = D[,,1,,,],
                   query = D[1,,,,,],
                   overall = D[1,,1,,,],
                   Anno = datamatrix$Anno)

for (i in seq_len(dim(D)[2])) {
  for (j in seq_len(dim(D)[4])) {
    for (k in seq_len(dim(D)[5])) {
      for (l in seq_len(dim(D)[6])) {
        MP = HD2013SGImaineffects(D[,i,,j,k,l],
            TargetNeg=which(TargetAnnotation$group == "negctrl"))
        pimatrix$D[,i,,j,k,l] = MP$pi
        mainEffects$target[,i,j,k,l] = MP$targetMainEffect
        mainEffects$query[i,,j,k,l] = MP$queryMainEffect
        mainEffects$overall[i,j,k,l] = MP$neg
      }
    }
  }
}
save(mainEffects, file=file.path("result","data","mainEffects.rda"))


###################################################
### code chunk number 41: callingInteractions1
###################################################
D = pimatrix$D
PADJ = D[pimatrix$Anno$target$group == "sample",,,,,1]
s = rep(NA_real_, dim(D)[5])
for (i in seq_len(dim(D)[5])) {
  Data = D[,,,,i,]
  Data = Data[pimatrix$Anno$target$group == "sample",,,,]
  d = dim(Data)
  dim(Data) = c(prod(d[1:4]),prod(d[5]))
  Data[abs(Data[,1]-Data[,2]) > 4*mad(Data[,1]-Data[,2],center=0.0),]=NA_real_

  s[i] = median(apply(Data,1,sd), na.rm=TRUE)
  padj = rep(NA_real_, nrow(Data))
  K = which(apply(!is.na(Data),1,all))
  fit = eBayes(lmFit(Data[K,]))
  padj[K] = p.adjust(fit$p.value, method="BH")
  PADJ[,,,,i] = padj
  cat(sprintf("i=%2d",i),
      " nr int (1%) = ", sum(padj <= 0.01, na.rm=TRUE)/nrow(Data),
      " nr int (3%) = ", sum(padj <= 0.03, na.rm=TRUE)/nrow(Data), "\n")
}


###################################################
### code chunk number 42: callingInteractions2
###################################################
PI = pimatrix$D
PI = PI[pimatrix$Anno$target$group == "sample",,,,,]
Interactions = list(newpiscore = PI,
                    scale = s,
                    padj = PADJ,
                    Anno = pimatrix$Anno)
Interactions$Anno$target = Interactions$Anno$target[
            pimatrix$Anno$target$group == "sample",]
save(Interactions, file=file.path("result","data","Interactions.rda"))


