### R code from vignette source 'src/sec05_convertData.Rnw'

###################################################
### code chunk number 1: convertData2
###################################################
library("HD2013SGI")


###################################################
### code chunk number 2: convertData3
###################################################
data("featuresPerWell", package="HD2013SGI")


###################################################
### code chunk number 3: convertData1
###################################################
NROW = 15
NCOL = 23
NFIELD = 4


###################################################
### code chunk number 4: convertData4
###################################################
dir.create(file.path("result","data"), recursive=TRUE, showWarnings=FALSE)


###################################################
### code chunk number 5: convertData3
###################################################
plates = featuresPerWell$Anno[seq(1, nrow(featuresPerWell$Anno), by=NFIELD*NCOL*NROW),"plate"]
PlateAnnotation = HD2013SGI:::parsePlateBarcodes(plates)
head(PlateAnnotation)


###################################################
### code chunk number 6: convertData4
###################################################
S = which(PlateAnnotation$queryGroup=="sample")
tdnames = unique(PlateAnnotation$targetDesign[S])
qnames = unique(PlateAnnotation$queryGene[S])
qdnames = unique(PlateAnnotation$queryDesign[S])
repnames = unique(PlateAnnotation$replicate[S])


###################################################
### code chunk number 7: convertData9
###################################################
D = array(0, dim=c(field=NFIELD, col=NCOL, row=NROW,
                     features=dim(featuresPerWell$data)[2],
                     targetDesign=length(tdnames),
                     query=length(qnames),
                     queryDesign=length(qdnames),
                     replicate=length(repnames)))
dimnames(D) = list(field=seq_len(NFIELD),
                   col=seq_len(NCOL), row=LETTERS[seq_len(NROW)+1],
                   features=dimnames(featuresPerWell$data)[[2]],
                   targetDesign=tdnames,
                   queryGene=qnames,
                   queryDesign=qdnames,
                   replicate=repnames)
for (td in tdnames) {
  for (q in qnames) {
    for (qd in qdnames) {
      for (r in repnames) {
        plate = PlateAnnotation$plate[
                    which((PlateAnnotation$targetDesign == td) &
                          (PlateAnnotation$queryGene    == q ) &
                          (PlateAnnotation$queryDesign  == qd) &
                          (PlateAnnotation$replicate    == r )) ]
        I = which(featuresPerWell$Anno$plate == plate)
        D[,,,,td,q,qd,r] = as.vector(featuresPerWell$data[I,])
      }
    }
  }
}
D[is.na(D)] = 0
D = (D[1,,,,,,,] + D[2,,,,,,,] + D[3,,,,,,,] + D[4,,,,,,,])/4
# faster than D = apply(D,2:8,mean,na.rm=TRUE)
dim(D)


###################################################
### code chunk number 8: convertData10
###################################################
D = aperm(D,c(1,2,4,5,6,3,7))
dn = dimnames(D)
dim(D) = c(prod(dim(D)[1:2]),dim(D)[3:7])
dimnames(D) = c(list(targetGene =
                       sprintf("%s%d",rep(LETTERS[seq_len(NROW)+1],each=NCOL),
                                      rep(seq_len(NCOL),times=NROW))),
                   dn[3:7])

datamatrixfull = list(D = D)
save(datamatrixfull, file=file.path("result","data","datamatrixfull.rda"))


