### R code from vignette source 'src/sec04_imageProcessing.Rnw'

###################################################
### code chunk number 1: imageProcessing1
###################################################
library("HD2013SGI")
dir.create(file.path("result","Figures"),recursive=TRUE,showWarnings=FALSE)


###################################################
### code chunk number 2: imageProcessing2
###################################################
fnch1 = system.file(file.path("images","image-DAPI.tif"), package="HD2013SGI")
fnch2 = system.file(file.path("images","image-FITC.tif"), package="HD2013SGI")
fnch3 = system.file(file.path("images","image-Cy3.tif"),  package="HD2013SGI")

Img1 = readImage(fnch1)
Img2 = readImage(fnch2)
Img3 = readImage(fnch3)


###################################################
### code chunk number 3: imageProcessing3
###################################################
ImgDAPI = normalize(Img1, inputRange=c(0.002, 0.03))
ImgFITC = normalize(Img2, inputRange=c(0.004, 0.04))
ImgCy3 = normalize(Img3,  inputRange=c(0.002, 0.03))


###################################################
### code chunk number 4: imageProcessing3 (eval = FALSE)
###################################################
## display(combine(ImgDAPI, ImgFITC, ImgCy3))


###################################################
### code chunk number 5: imageProcessing4
###################################################
writeImage(ImgDAPI,file.path("result","Figures","image-ImgDAPI.jpg"),quality=98)
writeImage(ImgFITC,file.path("result","Figures","image-ImgFITC.jpg"),quality=98)
writeImage(ImgCy3,file.path("result","Figures","image-ImgCy3.jpg"),quality=98)


###################################################
### code chunk number 6: imageProcessing5
###################################################
ImgColor = rgbImage(ImgCy3,ImgFITC,ImgDAPI)


###################################################
### code chunk number 7: imageProcessing6 (eval = FALSE)
###################################################
## display(ImgColor)


###################################################
### code chunk number 8: imageProcessing7
###################################################
writeImage(ImgColor,file.path("result","Figures","image-ImgColor.jpg"),quality=98)


###################################################
### code chunk number 9: imageProcessing8
###################################################
Filter1 = makeBrush(size=51,shape = "gaussian",sigma=1)/12.91571
Filter3 = makeBrush(size=51,shape = "gaussian",sigma=3)/12.91571
Img1smooth = filter2(Img1, filter=Filter1)
Img2smooth = filter2(Img2, filter=Filter3)
Img3smooth = filter2(Img3, filter=Filter3)


###################################################
### code chunk number 10: imageProcessing9
###################################################
smoothDAPI = normalize(Img1smooth*12.91571, inputRange=c(0.002, 0.03))
smoothFITC = normalize(Img2smooth*12.91571, inputRange=c(0.004, 0.04))
smoothCy3 = normalize(Img3smooth*12.91571,  inputRange=c(0.002, 0.03))


###################################################
### code chunk number 11: imageProcessing10 (eval = FALSE)
###################################################
## display(combine(smoothDAPI,smoothFITC,smoothCy3))


###################################################
### code chunk number 12: imageProcessing11
###################################################
writeImage(smoothDAPI, file.path("result","Figures","image-smoothDAPI.jpg"),quality=98)
writeImage(smoothFITC, file.path("result","Figures","image-smoothFITC.jpg"),quality=98)
writeImage(smoothCy3,  file.path("result","Figures","image-smoothCy3.jpg"), quality=98)


###################################################
### code chunk number 13: imageProcessing12
###################################################
nucleusThresh = thresh(Img1smooth, w = 10, h = 10, offset = 0.0001)


###################################################
### code chunk number 14: imageProcessing13
###################################################
nucleusOpening = opening(nucleusThresh, kern=makeBrush(3, shape="disc"))


###################################################
### code chunk number 15: imageProcessing14
###################################################
nucleusSeed = bwlabel(nucleusOpening)


###################################################
### code chunk number 16: imageProcessing15
###################################################
nucleusFill = fillHull(thresh(Img1smooth, w = 20, h = 20, offset = 0.00005))


###################################################
### code chunk number 17: imageProcessing16
###################################################
nucleusRegions = propagate(Img1smooth, nucleusSeed, mask=nucleusFill)


###################################################
### code chunk number 18: imageProcessing17 (eval = FALSE)
###################################################
## display(combine(nucleusThresh,
##                 nucleusOpening,
##                 colorLabels(nucleusSeed),
##                 nucleusFill,
##                 colorLabels(nucleusRegions)))


###################################################
### code chunk number 19: imageProcessing18
###################################################
writeImage(nucleusThresh,
           file.path("result","Figures","image-seg-nucleusThresh.jpg"),quality=98)
writeImage(nucleusOpening,
           file.path("result","Figures","image-seg-nucleusOpening.jpg"),quality=98)
writeImage(colorLabels(nucleusSeed),
           file.path("result","Figures","image-seg-nucleusSeed.jpg"),quality=98)
writeImage(nucleusFill,
           file.path("result","Figures","image-seg-nucleusFill.jpg"),quality=98)
writeImage(colorLabels(nucleusRegions),
           file.path("result","Figures","image-seg-nucleusRegions.jpg"),quality=98)


###################################################
### code chunk number 20: imageProcessing19
###################################################
cytoplasmThresh = thresh(Img3smooth, w = 20, h = 20, offset = 0.000001)
cytoplasmOpening = opening(cytoplasmThresh,kern=makeBrush(3,shape="disc"))


###################################################
### code chunk number 21: imageProcessing20
###################################################
globalThreshold = 0.0003
cytoplasmOpening2 = opening(Img3smooth > globalThreshold)


###################################################
### code chunk number 22: imageProcessing21
###################################################
cytoplasmCombined = cytoplasmOpening
cytoplasmCombined[cytoplasmOpening2 > cytoplasmCombined] =
              cytoplasmOpening2[cytoplasmOpening2 > cytoplasmCombined]
cytoplasmCombined[nucleusFill > cytoplasmCombined] =
              nucleusFill[nucleusFill > cytoplasmCombined]


###################################################
### code chunk number 23: imageProcessing22
###################################################
cytoplasmRegions = propagate(Img3smooth, nucleusRegions, lambda=1.0e-4, mask=cytoplasmCombined)


###################################################
### code chunk number 24: imageProcessing23 (eval = FALSE)
###################################################
## display(combine(cytoplasmThresh,
##                 cytoplasmOpening,
##                 cytoplasmOpening2,
##                 cytoplasmCombined,
##                 colorLabels(cytoplasmRegions)))


###################################################
### code chunk number 25: imageProcessing24
###################################################
writeImage(cytoplasmThresh,
           file.path("result","Figures","image-seg-cytoplasmThresh.jpg"),quality=98)
writeImage(cytoplasmOpening,
           file.path("result","Figures","image-seg-cytoplasmOpening.jpg"),quality=98)
writeImage(cytoplasmOpening2,
           file.path("result","Figures","image-seg-cytoplasmOpening2.jpg"),quality=98)
writeImage(cytoplasmCombined,
           file.path("result","Figures","image-seg-cytoplasmCombined.jpg"),quality=98)
writeImage(colorLabels(cytoplasmRegions),
           file.path("result","Figures","image-seg-cytoplasmRegions.jpg"),quality=98)


###################################################
### code chunk number 26: imageProcessing25
###################################################
  Imgout1 = paintObjects(nucleusRegions,ImgDAPI, col='#ff00ff')
  Imgout2 = paintObjects(nucleusRegions,ImgColor, col='#ff00ff')
  Imgout3 = paintObjects(cytoplasmRegions,
                         paintObjects(nucleusRegions,
                                      toRGB(ImgDAPI),
                                      col='#ff00ff'),
                         col='#ff0000')
  Imgout4 = paintObjects(cytoplasmRegions,
                         paintObjects(nucleusRegions,
                                      toRGB(ImgCy3),
                                      col='#ff00ff'),
                         col='#ff0000')
  Imgout5 = paintObjects(cytoplasmRegions,
                         paintObjects(nucleusRegions,ImgColor, col='#ff00ff'),
                         col='#ff0000')


###################################################
### code chunk number 27: imageProcessing26
###################################################
writeImage(Imgout1,
           file.path("result","Figures","image-seg-Imgout1.jpg"),quality=98)
writeImage(Imgout2,
           file.path("result","Figures","image-seg-Imgout2.jpg"),quality=98)
writeImage(Imgout3,
           file.path("result","Figures","image-seg-Imgout3.jpg"),quality=98)
writeImage(Imgout4,
           file.path("result","Figures","image-seg-Imgout4.jpg"),quality=98)
writeImage(Imgout5,
           file.path("result","Figures","image-seg-Imgout5.jpg"),quality=98)


###################################################
### code chunk number 28: imageProcessing27
###################################################
F1 = computeFeatures(nucleusRegions,  Img1, xname="nuc",  refnames="nuc")
F2 = computeFeatures(cytoplasmRegions,Img2, xname="cell", refnames="tub")
F3 = computeFeatures(cytoplasmRegions,Img3, xname="cell", refnames="act")


###################################################
### code chunk number 29: imageProcessing28
###################################################
F4 = computeFeatures(cytoplasmRegions, (Img1 - mean(Img1)) * (Img2 - mean(Img2)),
                     xname="cell", refnames="nuctub")


###################################################
### code chunk number 30: imageProcessing29
###################################################
pdf(file=file.path("result","Figures","image-features.pdf"),width=12,height=6)
vp = viewport(layout=grid.layout(nrow=3,ncol=7,
                                 widths=c(dim(Img1)[1],rep(c(0.07,0.7)*dim(Img1)[1],3)),
                                 heights=c(0.01*dim(Img1)[2],dim(Img1)[2],0.15*dim(Img1)[2]),respect=TRUE))
pushViewport(vp)
pushViewport(viewport(layout.pos.row=2,layout.pos.col=1,xscale=c(0.5,dim(Img1)[1]+0.5),yscale=c(dim(Img1)[2]+0.5,0.5)))
grid.raster(Imgout5)
#grid.points(F1[,1],F1[,2],default.units="native",gp=gpar(col="white"))
grid.polyline(x=c(F1[,1],rep(dim(Img1)[1]+0.5,nrow(F1))),
              y=c(F1[,2],F1[,2]),id=c(seq_len(nrow(F1)),seq_len(nrow(F1))),
              default.units="native",gp=gpar(col="gray"))
popViewport()

#########
## nucleus area
f = F1[,"nuc.0.s.area"]
r = range(f,finite=TRUE)
pushViewport(viewport(layout.pos.row=2,layout.pos.col=3,
                      xscale=r,
                      yscale=c(dim(Img1)[2]+0.5,0.5)))
grid.rect(gp=gpar(fill="gray90",col=NA))
grid.polyline(x=c(rep(r[1]-0.1*diff(r),nrow(F1)),rep(r[2],nrow(F1))),
              y=c(F1[,2],F1[,2]),id=c(seq_len(nrow(F1)),seq_len(nrow(F1))),
              default.units="native",gp=gpar(col="gray"))
m = mean(f)
grid.lines(x=unit(c(m,m),"native"),
          y=unit(c(0,1),"npc")+unit(c(-1,1),"lines"))
grid.points(f,F1[,2],default.units="native",pch=20)
grid.xaxis()
grid.text(x=unit(0.5,"npc"),y=unit(-3,"lines"),just=c("center","top"),label="nucleus area")
popViewport()

#########
## cell eccentricity
f = F3[,"cell.0.m.eccentricity"]
r = range(f,finite=TRUE)
pushViewport(viewport(layout.pos.row=2,layout.pos.col=5,
                      xscale=r,
                      yscale=c(dim(Img1)[2]+0.5,0.5)))
grid.rect(gp=gpar(fill="gray90",col=NA))
grid.polyline(x=c(rep(r[1]-0.1*diff(r),nrow(F1)),rep(r[2],nrow(F1))),
              y=c(F1[,2],F1[,2]),id=c(seq_len(nrow(F1)),seq_len(nrow(F1))),
              default.units="native",gp=gpar(col="gray"))
m = mean(f)
grid.lines(x=unit(c(m,m),"native"),
          y=unit(c(0,1),"npc")+unit(c(-1,1),"lines"))
grid.points(f,F1[,2],default.units="native",pch=20)
grid.xaxis()
grid.text(x=unit(0.5,"npc"),y=unit(-3,"lines"),just=c("center","top"),label="cell eccentricity")
popViewport()

#########
## tubulin intensity
f = F2[,"cell.tub.b.mean"]
r = range(f,finite=TRUE)
pushViewport(viewport(layout.pos.row=2,layout.pos.col=7,
                      xscale=r,
                      yscale=c(dim(Img1)[2]+0.5,0.5)))
grid.rect(gp=gpar(fill="gray90",col=NA))
grid.polyline(x=c(rep(r[1]-0.1*diff(r),nrow(F1)),f),
              y=c(F1[,2],F1[,2]),id=c(seq_len(nrow(F1)),seq_len(nrow(F1))),
              default.units="native",gp=gpar(col="gray"))
m = mean(f)
grid.lines(x=unit(c(m,m),"native"),
          y=unit(c(0,1),"npc")+unit(c(-1,1),"lines"))
grid.points(f,F1[,2],default.units="native",pch=20)
grid.xaxis()
grid.text(x=unit(0.5,"npc"),y=unit(-3,"lines"),just=c("center","top"),label="tubulin intensity")
popViewport()
popViewport()
dev.off()


###################################################
### code chunk number 31: imageProcessing29
###################################################
F = cbind(F1, F2, F3, F4)
Fwell = c(count=nrow(F), apply(F, 2, mean))


