### =========================================================================
### EMTscoreData metadata
### -------------------------------------------------------------------------
###

meta <- data.frame(
  Title = c("MCF7_TNF.rda",
            "MCF7_EGF.rda",
            "MCF7_TGFB1.rda",
            "OVCA420_TNF.rda",
            "OVCA420_EGF.rda",
            "OVCA420_TGFB1.rda",
            "DU145_TNF.rda",
            "DU145_EGF.rda",
            "DU145_TGFB1.rda",
            "A549_TNF.rda",
            "A549_EGF.rda",
            "A549_TGFB1.rda"),
  Location_Prefix = rep("https://zenodo.org/", 12),
  Description = c("MCF7 cells treated with TNF for various periods of time",
                  "MCF7 cells treated with EGF for various periods of time",
                  "MCF7 cells treated with TGFB1 for various periods of time",
                  "OVCA420 cells treated with TNF for various periods of time",
                  "OVCA420 cells treated with EGF for various periods of time",
                  "OVCA420 cells treated with TGFB1 for various periods of time",
                  "DU145 cells treated with TNF for various periods of time",
                  "DU145 cells treated with EGF for various periods of time",
                  "DU145 cells treated with TGFB1 for various periods of time",
                  "A549 cells treated with TNF for various periods of time",
                  "A549 cells treated with EGF for various periods of time",
                  "A549 cells treated with TGFB1 for various periods of time"),
  BiocVersion = rep("3.21", 12),
  Genome = rep("Homo sapiens", 12),
  SourceType = rep("RDA", 12),
  SourceUrl = c("https://zenodo.org/records/18168504/files/MCF7_TNF.rda",
                "https://zenodo.org/records/18168504/files/MCF7_EGF.rda",
                "https://zenodo.org/records/18168504/files/MCF7_TGFB1.rda",
                "https://zenodo.org/records/18168504/files/OVCA420_TNF.rda",
                "https://zenodo.org/records/18168504/files/OVCA420_EGF.rda",
                "https://zenodo.org/records/18168504/files/OVCA420_TGFB1.rda",
                "https://zenodo.org/records/18168504/files/DU145_TNF.rda",
                "https://zenodo.org/records/18168504/files/DU145_EGF.rda",
                "https://zenodo.org/records/18168504/files/DU145_TGFB1.rda",
                "https://zenodo.org/records/18168504/files/A549_TNF.rda",
                "https://zenodo.org/records/18168504/files/A549_EGF.rda",
                "https://zenodo.org/records/18168504/files/A549_TGFB1.rda"),
  SourceVersion = rep("June 11 2019", 12),
  Species = rep("Homo sapiens", 12),
  TaxonomyId = rep(9606, 12),
  Coordinate_1_based = rep(TRUE, 12),
  DataProvider = rep("David P. Cook", 12),
  Maintainer = rep("David P. Cook <dpcook.lab@gmail.com>", 12),
  RDataClass = rep("SingleCellExperiment", 12),
  DispatchClass = rep("Rda", 12),
  RDataPath = c("records/18168504/files/MCF7_TNF.rda",
                "records/18168504/files/MCF7_EGF.rda",
                "records/18168504/files/MCF7_TGFB1.rda",
                "records/18168504/files/OVCA420_TNF.rda",
                "records/18168504/files/OVCA420_EGF.rda",
                "records/18168504/files/OVCA420_TGFB1.rda",
                "records/18168504/files/DU145_TNF.rda",
                "records/18168504/files/DU145_EGF.rda",
                "records/18168504/files/DU145_TGFB1.rda",
                "records/18168504/files/A549_TNF.rda",
                "records/18168504/files/A549_EGF.rda",
                "records/18168504/files/A549_TGFB1.rda"),
  Tags = rep(paste("scRNA-seq;Homo sapiens;SingleCellExperiment;EMT"),12))

write.csv(meta, file="inst/extdata/metadata.csv", row.names=FALSE)
