##########################################################################
##
## CENTREexperiment: Precomputed fisher p -values and bam files for CENTRE
## package
##
##########################################################################

meta <- data.frame(
	Title = c("Precomputed Fisher combined p-values and crup correlations database",
	"H3K4me3 ChIP-seq HeLa-S3 from ENCODE",
	"H3K4me1 ChIP-seq HeLa-S3 from ENCODE",
	"H3K27ac ChIP-seq HeLa-S3 from ENCODE",
	"Control ChIP-seq HeLa-S3 from ENCODE",
	"RNA-seq gene quantifications HeLa-S3 from ENCODE",
	"H3K4me3 ChIP-seq HeLa-S3 from ENCODE",
	"H3K4me1 ChIP-seq HeLa-S3 from ENCODE",
	"H3K27ac ChIP-seq HeLa-S3 from ENCODE",
	"Control ChIP-seq HeLa-S3 from ENCODE"),
	Description = c(paste0("Precomputed Fisher combined p-values computed "
	,"from the p-values of the accross cell-type CAGE-seq, ",
	"DNAse-hypersensitive region dataset, DNAse-seqgene expression dataset ",
	"CRUP-EP-gene expression dataset wilcoxon rank-sum tests. Additonaly, ",
	"the database contains the precomputed crup scores correlations."),
	"Example input H3K4me3 ChIP-seq HeLa-S3 from ENCODE only chr 19",
	"Example input H3K4me1 ChIP-seq HeLa-S3 from ENCODE only chr 19",
	"Example input H3K27ac ChIP-seq HeLa-S3 from ENCODE only chr 19",
	"Example input Control ChIP-seq HeLa-S3 from ENCODE only chr 19",
	"Example input RNA-seq gene quantifications HeLa-S3 from ENCODE",
	"Example input H3K4me3 ChIP-seq HeLa-S3 from ENCODE only chr 19 BAM index",
	"Example input H3K4me1 ChIP-seq HeLa-S3 from ENCODE only chr 19 BAM index",
	"Example input H3K27ac ChIP-seq HeLa-S3 from ENCODE only chr 19 BAM index",
	"Example input Control ChIP-seq HeLa-S3 from ENCODE only chr 19 BAM index"),
	BiocVersion = rep("3.19", 10),
	Genome = rep("GRCh38", 10), 
	SourceType = c(paste0("BED"),
	              rep("BAM", 4), 
	              "TSV",
	              rep("BAI", 4)),
	SourceUrl = c(paste0("https://fantom.gsc.riken.jp/5/datafiles/reprocessed/hg38_latest/extra/\n",
	                     "http://big.databio.org/papers/RED/supplement/\n",
	                     "http://big.databio.org/papers/RED/supplement/\n",
	                     "http://owww.molgen.mpg.de/~CENTRE_data/In_house_constructed_datasets.zip\n",
	                     "http://owww.molgen.mpg.de/~CENTRE_data/In_house_constructed_datasets.zip"),
	"https://www.encodeproject.org/experiments/ENCSR340WQU/",
	"https://www.encodeproject.org/experiments/ENCSR000APW/",
	"https://www.encodeproject.org/experiments/ENCSR000AOC/",
	"https://www.encodeproject.org/experiments/ENCSR000AOB/",
	"https://www.encodeproject.org/experiments/ENCSR000CPP/",
	"https://www.encodeproject.org/experiments/ENCSR340WQU/",
	"https://www.encodeproject.org/experiments/ENCSR000APW/",
	"https://www.encodeproject.org/experiments/ENCSR000AOC/",
	"https://www.encodeproject.org/experiments/ENCSR000AOB/"),
	SourceVersion = c("NA", 
	                rep("ENCODE4 v1.5.1 GRCh38", 4), 
	                "ENCODE4 v1.2.3 GRCh38 V29",
	                rep("ENCODE4 v1.5.1 GRCh38", 4)), 
	Species = rep("Homo sapiens", 10),
	TaxonomyId = rep(9606, 10),
	Coordinate_1_based = rep(TRUE,10), 
	DataProvider = c("FANTOM5, big.databio.org and MPI for molecular genetics",
	                 rep("ENCODE", 9)),
	Maintainer = rep("Sara Lopez <lopez_s@molgen.mpg.de>", 10) ,
	RDataClass = c("SQLiteConnection", rep("character", 9)),
	DispatchClass = c("SQLiteFile",  rep("FilePath", 9)),
	Location_Prefix = c(rep("http://owww.molgen.mpg.de/~CENTRE_data/", 10)),
	RDataPath = c("CENTREexperimentData/PrecomputedDataLight.db", 
	              "CENTREexperimentData/example/HeLa_H3K4me3.REF_chr19.bam",
	              "CENTREexperimentData/example/HeLa_H3K4me1.REF_chr19.bam",
	              "CENTREexperimentData/example/HeLa_H3K27ac.REF_chr19.bam",
	              "CENTREexperimentData/example/HeLa_input.REF_chr19.bam",
	              "CENTREexperimentData/example/HeLa-S3.tsv",
	              "CENTREexperimentData/example/HeLa_H3K4me3.REF_chr19.bam.bai",
	              "CENTREexperimentData/example/HeLa_H3K4me1.REF_chr19.bam.bai",
	              "CENTREexperimentData/example/HeLa_H3K27ac.REF_chr19.bam.bai",
	              "CENTREexperimentData/example/HeLa_input.REF_chr19.bam.bai"),
	Tags = c(rep("ExperimentHub:ExperimentData:PackageTypeData", 10))
)

write.csv(meta, file = system.file("extdata",
                                  "metadata.csv",
                                  package = "CENTREprecomputed"),
          row.names=FALSE)

 	