datacache <- new.env(hash=TRUE, parent=emptyenv())

org.Cf.eg <- function() showQCData("org.Cf.eg", datacache)
org.Cf.eg_dbconn <- function() dbconn(datacache)
org.Cf.eg_dbfile <- function() dbfile(datacache)
org.Cf.eg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
org.Cf.eg_dbInfo <- function() dbInfo(datacache)

org.Cf.egORGANISM <- "Canis familiaris"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "org.Cf.eg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"OrgDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("CANINE_DB", "org.Cf.eg", "Canine", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("org.Cf.eg"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(org.Cf.eg_dbconn())
}

