% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zenithPR_gsa.R
\name{zenithPR_gsa}
\alias{zenithPR_gsa}
\title{Gene set analysis using pre-computed test statistic}
\usage{
zenithPR_gsa(
  statistics,
  ids,
  geneSets,
  use.ranks = FALSE,
  n_genes_min = 10,
  progressbar = TRUE,
  inter.gene.cor = 0.01,
  coef.name = "zenithPR"
)
}
\arguments{
\item{statistics}{pre-computed test statistics}

\item{ids}{name of gene for each entry in \code{statistics}}

\item{geneSets}{\code{GeneSetCollection}}

\item{use.ranks}{do a rank-based test \code{TRUE} or a parametric test \code{FALSE}? default: FALSE}

\item{n_genes_min}{minumum number of genes in a geneset}

\item{progressbar}{if TRUE, show progress bar}

\item{inter.gene.cor}{correlation of test statistics with in gene set}

\item{coef.name}{name of column to store test statistic}
}
\value{
\itemize{
  \item \code{NGenes}: number of genes in this set
  \item \code{Correlation}: mean correlation between expression of genes in this set
  \item \code{delta}: difference in mean t-statistic for genes in this set compared to genes not in this set
  \item \code{se}: standard error of \code{delta}
  \item \code{p.less}: p-value for hypothesis test of \code{H0: delta < 0}
  \item \code{p.greater}: p-value for hypothesis test of \code{H0: delta > 0}
  \item \code{PValue}:  p-value for hypothesis test \code{H0: delta != 0}
  \item \code{Direction}: direction of effect based on sign(delta)
  \item \code{FDR}: false discovery rate based on Benjamini-Hochberg method in \code{p.adjust}
  \item \code{coef.name}: name for pre-computed test statistics. Default: \code{zenithPR}
}
}
\description{
Perform gene set analysis on the result of a pre-computed test statistic.  Test whether statistics in a gene set are larger/smaller than statistics not in the set.
}
\details{
This is the same as \code{zenith_gsa()}, but uses pre-computed test statistics.  Note that \code{zenithPR_gsa()} may give slightly different results for small samples sizes, if \code{zenithPR_gsa()} is fed t-statistics instead of z-statistics.
}
\examples{
# Load packages
library(edgeR)
library(variancePartition)
library(tweeDEseqCountData)

# Load RNA-seq data from LCL's
data(pickrell)
geneCounts = exprs(pickrell.eset)
df_metadata = pData(pickrell.eset)

# Filter genes
# Note this is low coverage data, so just use as code example
dsgn = model.matrix(~ gender, df_metadata)
keep = filterByExpr(geneCounts, dsgn, min.count=5)

# Compute library size normalization
dge = DGEList(counts = geneCounts[keep,])
dge = calcNormFactors(dge)

# Estimate precision weights using voom
vobj = voomWithDreamWeights(dge, ~ gender, df_metadata)

# Apply dream analysis
fit = dream(vobj, ~ gender, df_metadata)
fit = eBayes(fit)

# Load Hallmark genes from MSigDB
# use gene 'SYMBOL', or 'ENSEMBL' id
# use get_GeneOntology() to load Gene Ontology
gs = get_MSigDB("H", to="ENSEMBL")
   
# Run zenithPR analysis with a test statistic for each gene
tab = topTable(fit, coef='gendermale', number=Inf)
	
res.gsa = zenithPR_gsa(tab$t, rownames(tab), gs)
}
\seealso{
\code{zenith_gsa()}, \code{limma::cameraPR()}
}
