% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qsmooth.R
\name{qsmooth}
\alias{qsmooth}
\title{Quantile shrinkage normalization}
\source{
\href{https://raw.githubusercontent.com/kokrah/qsmooth/master/R/qsmooth.r}{Kwame Okrah's qsmooth R package}
}
\usage{
qsmooth(obj, groups, norm.factors = NULL, plot = FALSE,
  window = 0.05, log = TRUE)
}
\arguments{
\item{obj}{for counts use log2(raw counts + 1)), for MA use log2(raw intensities)}

\item{groups}{groups to which samples belong (character vector)}

\item{norm.factors}{scaling normalization factors}

\item{plot}{plot weights? (default=FALSE)}

\item{window}{window size for running median (a fraction of the number of rows of exprs)}

\item{log}{Whether or not the data should be log transformed before normalization, TRUE = YES.}
}
\value{
Normalized expression
}
\description{
This function was modified from github user kokrah.
}
\examples{
data(skin)
head(yarn:::qsmooth(skin,groups=pData(skin)$SMTSD))

}
