% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-XCMSnExp.R
\name{groupnames,XCMSnExp-method}
\alias{groupnames,XCMSnExp-method}
\title{Generate unique group (feature) names based on mass and retention time}
\usage{
\S4method{groupnames}{XCMSnExp}(object, mzdec = 0, rtdec = 0, template = NULL)
}
\arguments{
\item{object}{\code{XCMSnExp} object containing correspondence results.}

\item{mzdec}{\code{integer(1)} with the number of decimal places to use for m/z (
defaults to \code{0}).}

\item{rtdec}{\code{integer(1)} with the number of decimal places to use for the
retention time (defaults to \code{0}).}

\item{template}{\code{character} with existing group names whose format should
be emulated.}
}
\value{
\code{character} with unique names for each feature in \code{object}. The
format is \verb{M(m/z)T(time in seconds)}.
}
\description{
\code{groupnames} generates names for the identified features from the
correspondence analysis based in their mass and retention time. This
generates feature names that are equivalent to the group names of the \emph{old}
user interface (aka xcms1).
}
\seealso{
\link{XCMSnExp}.
}
