% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WrapperFuncs.R
\name{enrichSTRING_API}
\alias{enrichSTRING_API}
\title{Enrichment Analysis via STRING REST API}
\usage{
enrichSTRING_API(
  genes,
  species = "none",
  category = "KEGG",
  adjpvalueCutoff = 0.05,
  verbose = FALSE
)
}
\arguments{
\item{genes}{Character vector of gene or protein identifiers recognized by STRING.}

\item{species}{A single numeric or string specifying the NCBI taxonomy ID
(e.g., \code{9606} for human). If \code{"none"} (default), no species is set in
the request, and STRING will attempt to auto-detect or may fail.}

\item{category}{One or more enrichment categories from STRING (e.g., \code{"KEGG"},
\code{"Process"}, etc.). Defaults to \code{"KEGG"} if unspecified.}

\item{adjpvalueCutoff}{Numeric cutoff for the BH-adjusted p-value (default 0.05).}

\item{verbose}{Logical indicating whether to print diagnostic messages (default \code{FALSE}).}
}
\value{
If any terms pass the cutoff, an \code{enrichResult} object
  (from \emph{clusterProfiler}) is returned. Otherwise, if \emph{clusterProfiler}
  is not installed or no terms pass filtering, the function either returns a
  data.frame (if installed but no terms pass) or \code{NULL}.
}
\description{
\code{enrichSTRING_API} performs a functional enrichment analysis by sending a
gene list to STRING's TSV API endpoint, retrieving enrichment results for one or
more categories (e.g., "KEGG"), and building a \code{clusterProfiler}-style result
object. It is intended as a lightweight replacement for older web-service–based
methods like \emph{RDAVIDWebService}.
}
\details{
This function:
\enumerate{
  \item Accepts a vector of \code{genes} recognized by STRING (e.g., Ensembl,
        UniProt, or commonly used gene symbols for a given species).
  \item Sends a \emph{POST} request to \url{https://string-db.org/api/tsv/enrichment} with
        those identifiers (and optionally \code{species}).
  \item Parses the returned \emph{TSV}-formatted enrichment data, which typically
        includes columns for \code{term}, \code{description}, \code{p_value}, and more.
  \item Optionally filters by \code{category} (e.g., "KEGG", "Process", etc.), applies
        \code{BH} multiple-testing correction, and removes terms above the
        \code{adjpvalueCutoff}.
  \item Returns an object of class \code{enrichResult} if \emph{clusterProfiler} is
        installed; otherwise, it simply returns the filtered data frame.
}

Note that this function does \emph{not} allow you to explicitly supply a custom
background gene set. The STRING API by default uses the entire known set of genes
or proteins for the specified species as the background. Also, the total number of
background genes is not reported by STRING; only how many of them map to each term.
}
\examples{
  library(httr)

  # A small gene set:
  gene_set <- c("TP53","BRCA1","BRCA2","EGFR")

  # Perform enrichment on KEGG terms for human (9606):
  enr <- enrichSTRING_API(
            genes       = gene_set,
            species     = 9606,
            category    = "KEGG",
            adjpvalueCutoff = 0.05,
            verbose     = TRUE
         )

  if (!is.null(enr)) {
    # If clusterProfiler is installed and some terms pass filtering, check results:
    head(enr@result)
  }
  
}
\seealso{
\href{https://string-db.org/help/api/}{STRING API documentation},
\code{\link{clusterProfiler}}.
}
