% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WrapperFuncs.R
\name{runFuncEnrich}
\alias{runFuncEnrich}
\title{Functional Enrichment with STRING}
\usage{
runFuncEnrich(cl, protnames = NULL, infosource)
}
\arguments{
\item{cl}{A clustering result. Typically either the direct output of
\code{vsclust_algorithm} or a \code{Bestcl} object from \code{ClustComp}
or \code{runClustWrapper}.}

\item{protnames}{Optional named vector mapping feature IDs (as in \code{cl$cluster})
to more interpretable gene/protein identifiers. If \code{NULL} (the default),
the feature names in \code{cl} themselves are used.}

\item{infosource}{Currently unused; previously indicated enrichment categories
when using DAVID. Kept for compatibility but is ignored in this version.}
}
\value{
A list with three components:
\describe{
  \item{\code{fullFuncs}}{The full \code{compareCluster} result from \code{enrichSTRING_API}.}
  \item{\code{redFuncs}}{A \code{compareClusterResult} object containing only
        the top 20 enriched terms (if more than 20 were detected).}
  \item{\code{BHI}}{A numeric value from \code{calcBHI} measuring cluster
        heterogeneity.}
}
}
\description{
\code{runFuncEnrich} performs a functional enrichment analysis for each cluster
of features (genes/proteins) using an \code{enrichSTRING_API} call (which queries
the STRING database). It replaces a previously used approach that relied on
\emph{RDAVIDWebService}, and is therefore more up to date.
}
\details{
The function takes a clustering result (e.g., from \code{vsclust_algorithm} or
\code{Bestcl} objects) and, for each cluster:
\enumerate{
  \item Extracts the member features with membership above 0.5.
  \item Optionally replaces their IDs with entries from \code{protnames}.
  \item Calls \code{compareCluster} (from \emph{clusterProfiler}) using a
        custom \code{enrichSTRING_API} function for the actual STRING-based enrichment.
}
The resulting \code{compareClusterResult} includes adjusted p-values (FDR),
and the top 20 enriched terms are retained if the total set is larger than 20.
}
\examples{
\dontrun{
  # Suppose 'mycl' is a clustering result from vsclust_algorithm,
  # and we have a named vector 'myProtnames' that maps feature IDs to gene symbols:

  res <- runFuncEnrich(mycl, protnames = myProtnames)
  res$fullFuncs  # The full compareCluster output
  res$redFuncs   # The top 20 enriched terms
  res$BHI        # The numeric BHI value
}

}
\seealso{
\code{\link{compareCluster}}, \code{\link{enrichSTRING_API}}
}
