% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrepareData.R
\name{pcaWithVar}
\alias{pcaWithVar}
\title{Visualize using principal component analysis (both loadings and scoring) 
including the variance from the replicates}
\usage{
pcaWithVar(data, NumReps, NumCond, Sds = 1)
}
\arguments{
\item{data}{Matrix of data frame with numerical values. Columns corresponds 
to samples}

\item{NumReps}{Number of replicates per experimental condition}

\item{NumCond}{Number of different experimental conditions}

\item{Sds}{Standard deviation for each features. Usually using the one from 
LIMMA}
}
\value{
Loading and scoring plots that include feature variance
}
\description{
The loading plot shows all features and their scaled variance. This provides 
an idea of the intrinsic noise in the data.
}
\examples{
data <- matrix(rnorm(1000), nrow=100)
pcaWithVar(data, NumCond=2, NumReps=5, Sds=1)
}
\references{
Schwaemmle V, Jensen ON. VSClust: feature-based variance-sensitive clustering 
of omics data. Bioinformatics. 2018 Sep 1;34(17):2965-2972. 
doi: 10.1093/bioinformatics/bty224. PMID: 29635359.

Schwaemmle V, Hagensen CE. A Tutorial for Variance-Sensitive Clustering and 
the Quantitative Analysis of Protein Complexes. Methods Mol Biol. 
2021;2228:433-451. doi: 10.1007/978-1-0716-1024-4_30. PMID: 33950508.

Schwaemmle V, Jensen ON. A simple and fast method to determine the parameters 
for fuzzy c-means cluster analysis. Bioinformatics. 2010 
Nov 15;26(22):2841-8. doi: 10.1093/bioinformatics/btq534. Epub 2010 Sep 29. 
PMID: 20880957.
}
