% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrepareData.R
\name{optimalClustNum}
\alias{optimalClustNum}
\title{Determine optimal cluster number from validity index}
\usage{
optimalClustNum(ClustInd, index = "MinCentroidDist", method = "VSClust")
}
\arguments{
\item{ClustInd}{Output from estimClustNum providing the calculated cluster 
validity indices}

\item{index}{Either "MinCentroidDist" or "XieBeni"}

\item{method}{Either "VSClust" or "FCM" for standard fuzzy c-means clustering}
}
\value{
optimal cluster number
}
\description{
Calculated the optimal number from expected behavior of the indices. This 
would be a large decay for the Minimum Centroid Distance and a minimum for 
the Xie Beni index
}
\examples{
  data("artificial_clusters")
  dat <- averageCond(artificial_clusters, 5, 10)
  dat <- scale(dat)
dat <- cbind(dat, 1)
ClustInd <- estimClustNum(dat, 6)
optimalClustNum
}
\references{
Schwaemmle V, Jensen ON. VSClust: feature-based variance-sensitive clustering 
of omics data. Bioinformatics. 2018 Sep 1;34(17):2965-2972. doi: 
10.1093/bioinformatics/bty224. PMID: 29635359.

Schwaemmle V, Hagensen CE. A Tutorial for Variance-Sensitive Clustering and 
the Quantitative Analysis of Protein Complexes. Methods Mol Biol. 
2021;2228:433-451. doi: 10.1007/978-1-0716-1024-4_30. PMID: 33950508.

Schwaemmle V, Jensen ON. A simple and fast method to determine the parameters 
for fuzzy c-means cluster analysis. Bioinformatics. 2010 Nov 15;26(22):2841-8. 
doi: 10.1093/bioinformatics/btq534. Epub 2010 Sep 29. PMID: 20880957.
}
