% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regionSummary.R
\name{regionSummary}
\alias{regionSummary}
\title{Compute regional methylation information for individual cells.}
\usage{
regionSummary(
  SE,
  region_ranges,
  sparseNAdrop = is_sparse(assays(SE)[[1]]),
  verbose = TRUE,
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{SE}{\code{SummarizedExperiment} object with one (and only one) assay that
contains *binary* methylation status of CpG sites in individual cells. In usual
analysis workflow (of vmrseq), \code{SE} should be the output of \code{vmrseq::data.pool}.}

\item{region_ranges}{\code{GRanges} object that contains genomic coordinates
of regions of interest.}

\item{sparseNAdrop}{logical value that represents whether the NA values are
droppped in the input \code{SE} object. \code{SE} objects output by
\code{vmrseq::data.pool} are NA dropped. See \code{?vmrseq::data.pool}
for details about NA-dropped representation.}

\item{verbose}{logical value that indicates whether progress messages
should be printed to stdout. Defaults value is TRUE.}

\item{BPPARAM}{a \code{BiocParallelParam} object to specify the parallel
backend. The default option is \code{BiocParallel::bpparam()} which will
automatically creates a cluster appropriate for the operating system.}
}
\value{
Returns a \code{SummarizedExperiment} object of dimension 
(# regions x # cells). In total the object contains thress assays. Specifically, 
`M` and `Cov` represent the number of methylated CpGs and the number of covered 
CpGs in each region per cell; and `MF` (stands for methylation fraction) represents 
the regional average methylation level computed by `M/Cov`.
}
\description{
This function summarize the methylated CpG count and total CpG count
per region per cell.
}
\examples{

# load example data
toy.se <- HDF5Array::loadHDF5SummarizedExperiment(system.file("extdata", "toy", package = "vmrseq"))
data(toy.results)

# run vmrseq.fit
regions.se <- regionSummary(SE = toy.se, region_ranges = toy.results$vmr.ranges[1:3])
regions.se

}
