% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genesetNetworks.R
\name{computeMsigNetwork}
\alias{computeMsigNetwork}
\title{Compute a network using computed gene set overlap}
\usage{
computeMsigNetwork(genesetOverlap, msigGsc)
}
\arguments{
\item{genesetOverlap}{a data.frame, containing results of an overlap analysis
computed using the \code{\link[=computeMsigOverlap]{computeMsigOverlap()}} function.}

\item{msigGsc}{a GeneSetCollection object, containing gene sets used to
compute overlap.}
}
\value{
an igraph object
}
\description{
Computes an igraph object using information on gene sets and gene sets
computed using the \code{\link[=computeMsigOverlap]{computeMsigOverlap()}} function.
}
\examples{
data(hgsc)
ovlap <- computeMsigOverlap(hgsc)
ig <- computeMsigNetwork(ovlap, hgsc)

}
