% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array_error_metrics.R
\name{.get_shared_neighbors}
\alias{.get_shared_neighbors}
\title{Calculate fraction of neighbors retained after mapping to new array
coordinates}
\usage{
.get_shared_neighbors(coords_new, coords)
}
\arguments{
\item{coords_new}{A \code{tibble()} containing \code{array_row}, \code{array_col}, \code{key},
and \code{capture_area} columns, representing data after mapping to new array
coordinates.}

\item{coords}{A \code{tibble()} containing \code{array_row}, \code{array_col}, \code{key},
and \code{capture_area} columns, representing data before mapping to new array
coordinates.}
}
\value{
A \code{tibble()} copy of \code{coords_new} with additional \code{shared_neighbors}
column.
}
\description{
Given \code{tibble()}s before and after mapping to new array coordinates,
calculate for each spot the fraction of starting neighboring spots that
were retained in the new array-coordinate system. Add this metric and
return.
}
\author{
Nicholas J. Eagles
}
\keyword{internal}
