% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projectedNeighbors.R
\name{asNNGraph}
\alias{asNNGraph}
\title{Function to produce idx and dist representation of a VeloViz graph}
\usage{
asNNGraph(vig)
}
\arguments{
\item{vig}{output of \code{buildVeloviz}}
}
\value{
\code{idx} numVertices x numNeighbors matrix, where each row i contains indices of vertex i's neighbors

\code{dist} numVertices x numNeighbors matrix, where each row i contains distances from vertex i to its neighbors
}
\description{
Function to produce idx and dist representation of a VeloViz graph
}
\examples{
data(vel)
curr <- vel$current
proj <- vel$projected

vv <- buildVeloviz(curr = curr, proj = proj, normalize.depth = TRUE,
use.ods.genes = FALSE, alpha = 0.05, pca = TRUE, nPCs = 3, center = TRUE,
scale = TRUE, k = 10, similarity.threshold = -1, distance.weight = 1,
distance.threshold = 1, weighted = TRUE, verbose = FALSE)

asNNGraph(vv)

}
