% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffVar.R
\docType{methods}
\name{diffVar}
\alias{diffVar}
\alias{diffVar,MArrayLM-method}
\title{Test differential variance}
\usage{
diffVar(
  fit,
  method = c("AD", "SQ"),
  scale = c("leverage", "none"),
  BPPARAM = SerialParam(),
  ...
)

\S4method{diffVar}{MArrayLM}(
  fit,
  method = c("AD", "SQ"),
  scale = c("leverage", "none"),
  BPPARAM = SerialParam(),
  ...
)
}
\arguments{
\item{fit}{model fit from \code{dream()}}

\item{method}{transform the residuals using absolute deviation ("AD") or squared deviation ("SQ").}

\item{scale}{scale each observation by "leverage", or no scaling ("none")}

\item{BPPARAM}{parameters for parallel evaluation}

\item{...}{other parameters passed to \code{dream()}}
}
\value{
\code{MArrayLM} object storing differential results to be passed to \code{topTable()}
}
\description{
Test the association between a covariate of interest and the response's deviation from expectation.
}
\details{
This method performs a test of differential variance between two subsets of the data, in a way that generalizes to multiple categories, continuous variables and metrics of spread beyond variance.  For the two category test, this method is simular to Levene's test.  This model was adapted from Phipson, et al (2014), extended to linear mixed models, and adapted to be compatible with \code{dream()}.

This method is composed of multiple steps where 1) a typical linear (mixed) model is fit with \code{dream()}, 2) residuals are computed and transformed based on an absolute value or squaring transform, 3) a second regression is performed with \code{dream()} to test if a variable is associated with increased deviation from expectation.  Both regression take advantage of the \code{dream()} linear (mixed) modelling framework followed by empirical Bayes shrinkage that extends the \code{limma::voom()} framework.

Note that \code{diffVar()} takes the results of the first regression as a parameter to use as a starting point.
}
\examples{
# library(variancePartition)
library(edgeR)
data(varPartDEdata)

# filter genes by number of counts
isexpr <- rowSums(cpm(countMatrix) > 0.1) >= 5

# Standard usage of limma/voom
dge <- DGEList(countMatrix[isexpr, ])
dge <- calcNormFactors(dge)

# make this vignette faster by analyzing a subset of genes
dge <- dge[1:1000, ]

# regression formula
form <- ~Disease

# estimate precision weights
vobj <- voomWithDreamWeights(dge, form, metadata)

# fit dream model
fit <- dream(vobj, form, metadata)
fit <- eBayes(fit)

# fit differential variance model
res <- diffVar(fit)

# extract results for differential variance based on Disease
topTable(res, coef = "Disease1", number = 3)

# Box plot of top hit
# Since ASCL3 has a negative logFC,
# the deviation from expectation is *smaller* in
# Disease==1 compared to baseline.
gene <- "ENST00000325884.1 gene=ASCL3"
boxplot(vobj$E[gene, ] ~ metadata$Disease, main = gene)

}
\references{
{
  \insertRef{phipson2014diffvar}{variancePartition}
}
}
\seealso{
\code{missMethyl::diffVar()}, \code{car::leveneTest()}
}
