% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ESS.R
\docType{methods}
\name{ESS}
\alias{ESS}
\alias{ESS,lmerMod-method}
\title{Effective sample size}
\usage{
ESS(fit, method = "full")

\S4method{ESS}{lmerMod}(fit, method = "full")
}
\arguments{
\item{fit}{model fit from lmer()}

\item{method}{"full" uses the full correlation structure of the model. The "approximate" method makes the simplifying assumption that the study has a mean of m samples in each of k groups, and computes m based on the study design.  When the study design is evenly balanced (i.e. the assumption is met), this gives the same results as the "full" method.}
}
\value{
effective sample size for each random effect in the model
}
\description{
Compute effective sample size based on correlation structure in linear mixed model
}
\details{
Effective sample size calculations are based on:

Liu, G., and Liang, K. Y. (1997). Sample size calculations for studies with correlated observations. Biometrics, 53(3), 937-47.

"full" method: if \deqn{V_x = var(Y;x)} is the variance-covariance matrix of Y, the response, based on the covariate x, then the effective sample size corresponding to this covariate is \deqn{\Sigma_{i,j} (V_x^{-1})_{i,j}}.  In R notation, this is: \code{sum(solve(V_x))}.  In practice, this can be evaluted as sum(w), where R %*% w == One and One is a column vector of 1's

"approximate" method: Letting m be the mean number of samples per group, \deqn{k} be the number of groups, and \deqn{\rho} be the intraclass correlation, the effective sample size is \deqn{mk / (1+\rho(m-1))}

Note that these values are equal when there are exactly m samples in each group.  If m is only an average then this an approximation.
}
\examples{
library(lme4)
data(varPartData)

# Linear mixed model
fit <- lmer(geneExpr[1, ] ~ (1 | Individual) + (1 | Tissue) + Age, info)

# Effective sample size
ESS(fit)

}
