% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/sort.uwmwRes.R
\name{unorder}
\alias{unorder}
\alias{sort}
\alias{sort,uwmwRes-method}
\alias{unorder,ANY-method}
\alias{unorder,uwmwRes-method}
\alias{order,uwmwRes-method}
\title{Sort and order method for uWMWRes objects}
\usage{
unorder(x, ...)

\S4method{sort}{uwmwRes}(
  x,
  decreasing = FALSE,
  which = c("or", "p", "se", "name", "z"),
  na.last = TRUE,
  ...
)

\S4method{unorder}{ANY}(x, ...)

\S4method{unorder}{uwmwRes}(x, ...)

\S4method{order}{uwmwRes}(
  ...,
  na.last = TRUE,
  decreasing = FALSE,
  method = c("auto", "shell", "radix")
)
}
\arguments{
\item{x}{a uwmwRes object}

\item{...}{currently ignored}

\item{decreasing}{a logical value indicating whether values should be sorted in increasing or decreasing order.}

\item{which}{a character value indicating on which values should be used to sort on. The possible values are: "or" for sorting on the odds ratio, "p" for sorting on the p value, "se" for sorting on the standard error or "name" for sorting on the gene names.}

\item{na.last}{a logical value indicating whether NA results should be sorted at the end. See \code{\link{order}} for more information.}

\item{method}{Argument of the generic, ignored here. See also
\code{\link[BiocGenerics]{order}}}
}
\value{
\code{sort} returns a sorted uwmwRes object.
}
\description{
This functions provide sorting functionality for \code{\link{uwmwRes}} objects. It allows to sort the values in the object in order to get the genes with the highest OR, lowest p value, ... The function uses \code{\link{order}} underneath
}
\details{
The function does not change the internal order, but changes the slot \code{id} in the object. This slot is used by other functions to give the requested values
}
\examples{
data(NBmat)
NBtest <- uWMW(NBmat, groups=NBgroups)
NBsort <- sort(NBtest,which="name")
NBsort[1:10]

}
\seealso{
The functions \code{\link{is.unsorted}}, \code{\link{orderedBy}} and \code{\link{getOrder}} to check on the ordered state of a \code{\link{uwmwRes}} object.

\code{order} returns the order of the uwmwRes object.

\code{unorder} returns a uwmwRes object with the order removed.
}
