context("Mahalanobis rain")

testDir <- system.file("testdata", package = "twoddpcr")

test_that("Mahalanobis rain does not break for small samples", {
  testWell <- ddpcrWell(file.path(testDir, "sample_B03_Amplitude.csv"))
  centres <- matrix(c(5000, 1500, 5500, 7000, 10000, 2000, 9000, 6000),
                    ncol=2, byrow=TRUE)
  testWell <- kmeansClassify(testWell, centres=centres)
  expect_error(mahalanobisRain(testWell, cMethod="kmeans", maxDistances=3), NA)
})

test_that("Mahalanobis rain removes ambiguous droplets", {
  testPlate <- ddpcrPlate(testDir)
  centres <- matrix(c(5000, 1500, 5500, 7000, 10000, 2000, 9000, 6000),
                    ncol=2, byrow=TRUE)
  testPlate <- kmeansClassify(testPlate, centres=centres)
  testPlate <- mahalanobisRain(testPlate, cMethod="kmeans", maxDistances=3)

  kmeansCl <- unlist(plateClassification(testPlate, cMethod="kmeans"))
  rainCl <- unlist(plateClassification(testPlate, cMethod="kmeansMahRain"))

  expect_true("kmeansMahRain" %in% commonClassificationMethod(testPlate))

  expect_lte(sum(rainCl == "NN"), sum(kmeansCl == "NN"))
  expect_lte(sum(rainCl == "NP"), sum(kmeansCl == "NP"))
  expect_lte(sum(rainCl == "PN"), sum(kmeansCl == "PN"))
  expect_lte(sum(rainCl == "PP"), sum(kmeansCl == "PP"))

  # The above tests are for <=, but the test data has been constructed so that
  # there are some major outliers, hence the following is strictly > 0.
  expect_gt(sum(rainCl == "Rain"), 0)

  # These should also be > 0.
  expect_gt(sum(rainCl == "NN"), 0)
  expect_gt(sum(rainCl == "NP"), 0)
  expect_gt(sum(rainCl == "PN"), 0)
  expect_gt(sum(rainCl == "PP"), 0)
})

