% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readCSVDataFrame.R
\name{extractWellNames}
\alias{extractWellNames}
\title{Try to get well names from a vector of filenames.}
\usage{
extractWellNames(filenames)
}
\arguments{
\item{filenames}{A character vector of filenames with .csv extension.}
}
\value{
A character vector of well names.
}
\description{
If each of the given filenames are of the form
"<PlateName>_<WellName>_Amplitude.csv", where <WellName> is of the form A01,
B01, etc., then this function can extract the <WellName> component.
Otherwise, the whole file name is assumed to be the well name.
}
\examples{
## Get the well names (recognised format).
extractWellNames(c("Sample_Plate_Name_G02_Amplitude.csv",
                   "Sample_Plate_Name_H02_Amplitude.csv",
                   "Sample_Plate_Name_A03_Amplitude.csv",
                   "Sample_Plate_Name_B03_Amplitude.csv"))

## Get the well names (unrecognised format).
extractWellNames(c("Sample_G02.csv",
                   "Sample_H02.csv",
                   "Sample_A03.csv",
                   "Sample_B03.csv"))

}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
