% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_Schwabe_stage.R
\name{estimate_Schwabe_stage}
\alias{estimate_Schwabe_stage}
\title{Assign cell cycle stages using Schwabe method}
\usage{
estimate_Schwabe_stage(
  x,
  exprs_values = "logcounts",
  batch.v = NULL,
  altexp = NULL,
  cycleGene.l = NULL,
  gname = NULL,
  gname.type = c("ENSEMBL", "SYMBOL"),
  species = c("mouse", "human"),
  AnnotationDb = NULL,
  corThres = 0.2,
  tolerance = 0.3
)
}
\arguments{
\item{x}{A numeric matrix of **log-expression** values where rows are features and columns are cells.
Alternatively, a \linkS4class{SummarizedExperiment} or \linkS4class{SingleCellExperiment} containing such a matrix.}

\item{exprs_values}{Integer scalar or string indicating which assay of \code{x} contains the **log-expression** values, which will be used for projection.
If the projection already exists, you can ignore this value. Default: 'logcounts'}

\item{batch.v}{A string specifies which column in colData of \linkS4class{SummarizedExperiment} or \linkS4class{SingleCellExperiment} to use as the batch variable.
Or it can be a vector, of which the number of elements equals to the number of columns of \code{x}. The 5 stage cell cycle assignments are preformed for each batch separately.
No \code{NA} is permitted. Default: NULL}

\item{altexp}{String or integer scalar specifying an alternative experiment containing the **log-expression** data, which will be used for projection.
If the projection is already calculated and stored in the \linkS4class{SingleCellExperiment} as a dimred, leave this value to default NULL.}

\item{cycleGene.l}{A list contains the marker genes for each stage. The stage names should be included as names of the elements. If user feed custom list,
they should make sure that the same gene id type for \code{x} and \code{cycleGene.l}. If not custom list is given, \code{\link{RevelioGeneList}} will be used.
Default: NULL}

\item{gname}{Alternative rownames of \code{x}. If provided, this will be used to map genes within \code{x} with genes in \code{ref.m}.
If not provided, the rownames of \code{x} will be used instead. Default: NULL}

\item{gname.type}{The type of gene names as in \code{gname} or rownames of \code{x}. It can be either 'ENSEMBL' or 'SYMBOL'. If the user uses
custom \code{ref.m}, this value will have no effect. Default: 'ENSEMBL'}

\item{species}{The type of species in \code{x}. It can be either 'mouse' or 'human'. If the user uses
custom \code{cycleGene.l}, this value will have no effect. Default: 'mouse'}

\item{AnnotationDb}{An AnnotationDb objects. It is used to map ENSEMBL IDs to gene SYMBOLs.
If no AnnotationDb object being given, the function will use \code{\link[org.Hs.eg.db]{org.Hs.eg.db}} or \code{\link[org.Mm.eg.db]{org.Mm.eg.db}} for human and mouse respectively.}

\item{corThres}{For each batch and each stage, correlations between expression of each gene and the mean of all genes belonging to that stage
will be calculated to filter the final gene list used for inference. The genes with a correlation between \code{corThres} will not be used for calculating \emph{z}-scores.
Default: 0.2}

\item{tolerance}{For each cell, the function will compare the largest two \emph{z}-scores. If the difference between those two \emph{z}-scores is less than \code{tolerance},
the cell will be treated un-assignable with \code{NA} value returned for that cell. Default: 0.3}
}
\value{
If the input is a numeric matrix, the discretized cell cycle stages - a factor vector corresponding to each cell will be returned.

If the input is \linkS4class{SummarizedExperiment}, the original \linkS4class{SummarizedExperiment} with the discretized cell cycle stages stored in colData with name 'CCStage' will be returned.

If the input is \linkS4class{SingleCellExperiment}, the original \linkS4class{SingleCellExperiment} with the discretized cell cycle stages stored in colData with name 'CCStage' will be returned.
}
\description{
The function is a re-implementation of cell cycle stage assignment method
proposed in Schwabe et al.(2020), with a little modification. The core
 assignment method is not designed by the authors of this package!
}
\details{
The function is a re-implementation of cell cycle stage assignment method
proposed in Schwabe et al.(2020), with a little modification. We include 
this function only for the purpose of convenience. The core assignment method
is not designed by the authors of this package!
Breiefly, the function assigns cells to discretized cell cycle stages by
 comparing the \emph{z}-scores calculated for each stage markers.
Without cycleGene.l input, \code{\link{RevelioGeneList}} will be used.
If you use this function, you should cite Schwabe et al.(2020).
}
\examples{
data(neurosphere_example, package = "tricycle")
neurosphere_example <- estimate_Schwabe_stage(neurosphere_example,
 gname.type = "ENSEMBL", species = "mouse")
neurosphere_example2 <- estimate_Schwabe_stage(neurosphere_example, batch.v = "sample")
neurosphere_example3 <- estimate_Schwabe_stage(neurosphere_example,
 batch.v = neurosphere_example$sample)
neurosphere_example <- project_cycle_space(neurosphere_example)
plot(reducedDim(neurosphere_example, "tricycleEmbedding"),
 col = neurosphere_example$CCStage)
}
\references{
Schwabe D, et al.
\emph{The transcriptome dynamics of single cells during the cell cycle.}
Molecular Systems Biology (2020) 16: e9946
doi:\href{https://doi.org/10.15252/msb.20209946}{10.15252/msb.20209946}.

Zheng SC, et al.
\emph{Universal prediction of cell cycle position using transfer learning.}
Genome Biology (2022) 23: 41
doi:\href{https://doi.org/10.1186/s13059-021-02581-y}{10.1186/s13059-021-02581-y}.
}
\author{
Shijie C. Zheng
}
