% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsetVarByCol.R
\name{upsetVarByCol}
\alias{upsetVarByCol}
\title{Show Variants by Impacted Columns}
\usage{
upsetVarByCol(
  gr,
  var,
  alt_col = "ALT",
  mcol = "transcript_id",
  ...,
  fill = NULL,
  fill_scale = scale_fill_discrete(),
  expand_sets = 0.2,
  hj_sets = 1.1,
  expand_intersect = 0.1,
  vj_intersect = -0.5,
  label_size = 3.5,
  title
)
}
\arguments{
\item{gr}{GRanges object with ranges representing a key feature such as exons}

\item{var}{GRanges object with variants in a given column}

\item{alt_col}{Column within \code{var} containing the alternate allele}

\item{mcol}{The column within \code{gr} to summarise results by}

\item{...}{Passed to \link[SimpleUpset:simpleUpSet]{SimpleUpset::simpleUpSet}}

\item{fill}{Optional column in gr used to fill intersections and sets}

\item{fill_scale}{Discrete ggplot2 scale for filling bars. Ignored if
\code{fill = NULL}}

\item{expand_sets}{Expand the set-size x-axis by this amount}

\item{hj_sets}{Horizontal adjustment of set size labels}

\item{expand_intersect}{Expand the intersection y-axis by this amount}

\item{vj_intersect}{Vertical adjustment of intersection size labels}

\item{label_size}{Control the size of both intersection and sit size labels}

\item{title}{Summary title to show above the intersection panel. Can be
hidden by setting to NULL}
}
\value{
An UpSet plot
}
\description{
Produce an UpSet plot showing unique values from a given column
}
\details{
Take a set of variants, classify them as SNV, Insertion and Deletion, then
using a GRanges object, produce an UpSet plot showing impacted values from
a given column
}
\examples{
library(rtracklayer)
library(VariantAnnotation)
library(ggplot2)
gtf <- import.gff(
    system.file("extdata/gencode.v44.subset.gtf.gz", package = "transmogR"),
    feature.type = "exon"
)
vcf <- system.file("extdata/1000GP_subset.vcf.gz", package = "transmogR")
var <- rowRanges(readVcf(vcf, param = ScanVcfParam(fixed = "ALT")))
upsetVarByCol(gtf, var)
upsetVarByCol(
  gtf, var, fill = "transcript_type",
  fill_scale = scale_fill_brewer(palette = "Set1")
)


}
\seealso{
\link[SimpleUpset:simpleUpSet]{SimpleUpset::simpleUpSet}
}
