% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transmogR-package.R
\docType{package}
\name{transmogR-package}
\alias{transmogR}
\alias{transmogR-package}
\title{transmogR: Create a variant-modified reference transcriptome}
\description{
The package \code{transmogR} has been designed for creation of a variant-modified
reference transcriptome
}
\details{
The package \code{transmogR} provides two primary functions for modifying complete
transcriptomes or genomes:
\itemize{
\item \code{\link[=transmogrify]{transmogrify()}} for incorporating the supplied variants into
transcriptomic sequences, and
\item \code{\link[=genomogrify]{genomogrify()}} for incorporating the supplied variants into genomic
sequences, ideally to be passed as decoy sequences to a tool such as \code{salmon}.
}

The main functions rely on lower-level functions such as:
\itemize{
\item \code{\link[=owl]{owl()}} which over-writes letters (i.e. SNPs) within a sequence, and
\item \code{\link[=indelcator]{indelcator()}} which incorporates InDels into an individual sequence
}

Additional utility functions are provided which allow characterisation and
exploration of any set of variants:
\itemize{
\item \code{\link[=overlapsByVar]{overlapsByVar()}} counts the variants which overlap sets of GenomicRanges,
first splitting the variants into SNV, Insertions and Deletions
\item \code{\link[=parY]{parY()}} returns the pseudo-autosomal regions for a chosen genome build as
a GenomicRanges object
\item \code{\link[=upsetVarByCol]{upsetVarByCol()}} produces an UpSet plot counting how many unique IDs are
impacted by a set o variants. IDs can represent any column in the supplied
ranges, such as gene_id or transcript_id
\item \code{\link[=varTypes]{varTypes()}} classifies a set of variants into SNV, Insertions of Deletions
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/smped/transmogR}
  \item Report bugs at \url{https://github.com/smped/transmogR/issues}
}

}
\author{
Stevie Pederson
}
\keyword{internal}
