% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k-mer-based.R
\name{estimate_significance_core}
\alias{estimate_significance_core}
\title{Significance of Observed Mean}
\usage{
estimate_significance_core(
  random_means,
  actual_mean,
  alternative = c("two_sided", "less", "greater"),
  conf_level = 0.95
)
}
\arguments{
\item{random_means}{numeric vector of means based on random permutations
of the data
(empirical null distribution)}

\item{actual_mean}{observed mean}

\item{alternative}{side of the test, one of the following:
\code{"two_sided"},
\code{"less"}, \code{"greater"}}

\item{conf_level}{confidence level for the returned confidence interval}
}
\value{
A list with the following components:
\tabular{rl}{
  \code{p_value_estimate} \tab the estimated p-value of the observed mean\cr
  \code{conf_int} \tab the confidence interval around that estimate
}
}
\description{
\code{estimate_significance_core} returns an estimate of the significance
of the observed
mean, given a vector of means based on random permutations of the data.
}
\examples{
test_sd <- 1.0
test_null_distribution <- rnorm(n = 10000, mean = 1.0, sd = test_sd)

estimate_significance_core(test_null_distribution, test_sd * 2, "greater")
}
\seealso{
Other \emph{k}-mer functions: 
\code{\link{calculate_kmer_enrichment}()},
\code{\link{check_kmers}()},
\code{\link{compute_kmer_enrichment}()},
\code{\link{count_homopolymer_corrected_kmers}()},
\code{\link{create_kmer_origin_list}()},
\code{\link{draw_volcano_plot}()},
\code{\link{estimate_significance}()},
\code{\link{generate_kmers}()},
\code{\link{generate_permuted_enrichments}()},
\code{\link{run_kmer_spma}()},
\code{\link{run_kmer_tsma}()}
}
\concept{\emph{k}-mer functions}
