% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TranscriptionDataSet-generics.R,
%   R/TranscriptionDataSet-methods.R
\docType{methods}
\name{transcriptsToBed}
\alias{transcriptsToBed}
\alias{transcriptsToBed,GRanges-method}
\title{transcriptsToBed}
\usage{
transcriptsToBed(object, file, strand.color = c("blue", "red"))

\S4method{transcriptsToBed}{GRanges}(object, file, strand.color = c("blue", "red"))
}
\arguments{
\item{object}{A \code{\link[GenomicRanges:GRanges-class]{GRanges}} object.}

\item{file}{\code{Character}. A file name.}

\item{strand.color}{A character vector of length two, specifying color for
each DNA strand. Default: c("blue", "red").}
}
\value{
A file in the BED format.
}
\description{
A convenient graphical way to explore the identified transcripts
is to visualize them in the
\href{https://genome.ucsc.edu/}{UCSC genome browser}.
The \code{transcriptsToBed} function returns a file in
\href{https://genome.ucsc.edu/FAQ/FAQformat.html#format1}{BED}
format, which can be directly uploaded to the genome browser.
To improve the visual perception, transcripts are color-coded by
DNA strand orientation.
}
\examples{
### Load TranscriptionDataSet object
data(tds)

### Load reference annotations (knownGene from UCSC)
data(annot)

### Detect transcripts
detectTranscripts(object = tds, coverage.cutoff = 5, gap.dist = 4000,
estimate.params = TRUE, combine.by.annot = FALSE, annot = annot)

### View detected transcripts
trx <- getTranscripts(tds)

### Export to BED
# transcriptsToBed(object = trx, file = "transcripts.bed",
# strand.color = c("blue", "red"))

}
\seealso{
\code{\link{estimateBackground}}
    \href{https://genome.ucsc.edu/}{UCSC genome browser}
    \href{https://genome.ucsc.edu/FAQ/FAQformat.html#format1}{BED}
}
\author{
Armen R. Karapetyan
}
