% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TranscriptionDataSet-generics.R,
%   R/TranscriptionDataSet-methods.R
\name{plotErrorRate}
\alias{plotErrorRate}
\alias{plotErrorRate,TranscriptionDataSet-method}
\title{plotErrorRate}
\usage{
plotErrorRate(
  object,
  color = c("#1B9E77", "#D95F02", "#7570B3"),
  xlab = "Gap distance (kb)",
  ylab = "Error rate",
  ...
)

\S4method{plotErrorRate}{TranscriptionDataSet}(
  object,
  color = c("#1B9E77", "#D95F02", "#7570B3"),
  xlab = "Gap distance (kb)",
  ylab = "Error rate",
  ...
)
}
\arguments{
\item{object}{A \code{\link{TranscriptionDataSet}} object.}

\item{color}{\code{Character}. Colors to be used to plot estimated
errors.}

\item{xlab}{\code{Character}. Label of the x-axis.}

\item{ylab}{\code{Character}. Lable of the y-axis.}

\item{...}{Further arguments passed to plot.}
}
\value{
plot
}
\description{
A simple helper function that plot results of
\code{\link{estimateGapDistance}} function call.
}
\details{
The tested gap distances are plotted on the x-axis and corresponding
    error rates on the y-axis. Three curved lines depict the two error
    types calculated by \code{\link{estimateGapDistance}} and the sum of
    both errors. The vertical dashed line depicts the gap distance with
    the smallest sum of two errors.
}
\examples{
### Load TranscriptionDataSet object
data(tds)

### Load reference annotations (knownGene from UCSC)
data(annot)

### Estimate gap distance minimazing error rate
### Define the range of gap distances to test
gdr <- seq(from = 0, to = 10000, by = 1000)

estimateGapDistance(object = tds, annot = annot, coverage.cutoff = 5,
filter.annot = FALSE, gap.dist.range = gdr)

plotErrorRate(object = tds, lwd = 2)

}
\seealso{
\code{\link{estimateGapDistance}}
}
\author{
Armen R. Karapetyan
}
