% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TranscriptionDataSet-generics.R,
%   R/TranscriptionDataSet-methods.R
\name{annotateTranscripts}
\alias{annotateTranscripts}
\alias{annotateTranscripts,TranscriptionDataSet,GRanges-method}
\title{annotateTranscripts}
\usage{
annotateTranscripts(object, annot, min.overlap = 0.3)

\S4method{annotateTranscripts}{TranscriptionDataSet,GRanges}(object, annot, min.overlap = 0.3)
}
\arguments{
\item{object}{A \code{\link{TranscriptionDataSet}} object.}

\item{annot}{\code{\link[GenomicRanges]{GRanges}}. Reference annotations.}

\item{min.overlap}{\code{Numeric}. A minimal proportion of the overlap between
transcript and annotation. A value in the range (0, 1]. Default: 0.3.}
}
\value{
An extra column \code{annotation.overlap} will be added to the metadata
    portion of the \code{\link[GenomicRanges]{GRanges}} object which is
    stored in the \code{transcripts} slot of the provided
    \code{\link{TranscriptionDataSet}} object.
}
\description{
Annotate detected transcripts by the available reference annotations based
on genomic overlap.
}
\details{
Genomic overlap between transcript and annotation is calculated as the
   mean of two proportions: 1) proportion of the transcript length overlapping
   annotation; 2) proportion of the annotation length overlapping transcript.
   This approach levels off differences in length between transcript
   and annotation and, thus better suitable for cases in which the length of
   either transcript or annotation is much longer than of compared element.

   If there is an overlap between transcript and annotation, the ID of the
   associated annotation will be linked to the transcript.
}
\examples{
### Load TranscriptionDataSet object
data(tds)

### Load reference annotations (knownGene from UCSC)
data(annot)

### Detect transcripts
detectTranscripts(object = tds, coverage.cutoff = 5, gap.dist = 4000,
estimate.params = TRUE, combine.by.annot = FALSE, annot = annot)

### Annotate detected transcripts
annotateTranscripts(object = tds, annot = annot)

### View detected transcripts and associated annotations
getTranscripts(tds)

}
\seealso{
\code{\link{detectTranscripts}}
}
\author{
Armen R. Karapetyan
}
