% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/conditionTest.R
\name{conditionTest}
\alias{conditionTest}
\alias{conditionTest,SingleCellExperiment-method}
\title{Assess differential expression patterns between conditions
within a lineage.}
\usage{
conditionTest(models, ...)

\S4method{conditionTest}{SingleCellExperiment}(
  models,
  global = TRUE,
  pairwise = FALSE,
  lineages = FALSE,
  knots = NULL,
  l2fc = 0,
  eigenThresh = 0.01
)
}
\arguments{
\item{models}{The fitted GAMs, typically the output from
\code{\link{fitGAM}}. For \code{conditionTest}, these are required to be
a \code{singleCellExperiment} object.}

\item{...}{parameters including:}

\item{global}{If TRUE, test for all pairwise comparisons simultaneously,
i.e. test for DE between all conditions in all lineages.}

\item{pairwise}{If TRUE, return output for all comparisons between pairs of conditions.
Both \code{global} and \code{pairwise} can be TRUE.}

\item{lineages}{If TRUE, return output for all comparisons within each lineage.
Both \code{global} and \code{lineages} can be TRUE. If both \code{lineages} and
\code{pairwise} are TRUE, the function returns output for all pairs of conditions
within each lineage.}

\item{knots}{Default to NULL. Otherwise, a vector of length 2 specifying the 
smallest and largest knots that are contrasted between conditions.}

\item{l2fc}{The log2 fold change threshold to test against. Note, that
this will affect both the global test and the pairwise comparisons.}

\item{eigenThresh}{Eigenvalue threshold for inverting the variance-covariance matrix
of the coefficients to use for calculating the Wald test statistics. Lower values
are more lenient to adding more information but also decrease computational stability.
This argument should in general not be changed by the user but is provided
for back-compatability. Set to \code{1e-8} to reproduce results of older
version of \code{tradeSeq}.}
}
\value{
A matrix with the wald statistic, the number of degrees of
freedom and the p-value associated with each gene for all the
tests performed.
}
\description{
Assess differential expression patterns between conditions
within a lineage.

Assess differential expression patterns between conditions
within a lineage.
}
\examples{
## artificial example
data(crv, package = "tradeSeq")
data("countMatrix", package = "tradeSeq")
conditions <- factor(sample(1:2, size = ncol(countMatrix), replace = TRUE))
sce <- fitGAM(as.matrix(countMatrix), sds = crv, conditions = conditions)
res <- conditionTest(sce)
}
