% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{geneCorHeatmap}
\alias{geneCorHeatmap}
\title{Correlation heatmap of genes}
\usage{
geneCorHeatmap(
  object,
  gene.df,
  group = "center",
  matrix = "scaled",
  size = 5,
  cor.method = "pearson"
)
}
\arguments{
\item{object}{A \code{SummarizedExperiment} object.}

\item{gene.df}{Data.frame. The first column must be a vector of gene names, and has the name \code{"gene"}. Additional columns in \code{gene.df} can be used to set the colors of genes.}

\item{group}{Character, a column name in \code{gene.df} defining the groups of genes. Genes in the same group have same colors on the side bar.}

\item{matrix}{Character, must be one of \code{"count"}, \code{"normalized"}, or \code{"scaled"}.}

\item{size}{Numeric, the size of gene names. Set it to 0 if you do not want to show gene names.}

\item{cor.method}{Character, the method to calculate correlation coefficients. must be one of \code{"pearson"}, \code{"kendall"}, or \code{"spearman"}.}
}
\value{
A \code{ggplot} object.
}
\description{
Heatmap of correlation coefficients between any two queried genes in a \code{SummarizedExperiment} object.
}
\details{
This method can create a pure heatmap or a heatmap with side bar. If you prefer a pure heatmap, input a \code{gene.df} with a single column of gene names.
However, you may want to show additional information of genes with a side bar, and the grouping information should be saved as additional column(s) of \code{gene.df}, and declared as \code{group}.
By default, you can use the output by \code{findPeakGene} as input \code{gene.df}. Peak genes will be grouped by their centers on the side bar.
}
\examples{
data(zh.data)
zh <- createTomo(zh.data)

# Correlation heatmap for all peak genes.
peak_genes <- findPeakGene(zh)
geneCorHeatmap(zh, peak_genes)

# Use Spearman correlation coefficients.
geneCorHeatmap(zh, peak_genes, cor.method="spearman")

# Group genes by peak start.
geneCorHeatmap(zh, peak_genes, group="start")

# Plot without side bar.
geneCorHeatmap(zh, data.frame(
 gene=c("ENSDARG00000002131", "ENSDARG00000003061", "ENSDARG00000076075", "ENSDARG00000076850")))
}
