% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{corHeatmap}
\alias{corHeatmap}
\title{Correlation heatmap of sections}
\usage{
corHeatmap(object, matrix = "scaled", max.cor = 0.5, cor.method = "pearson")
}
\arguments{
\item{object}{A \code{SummarizedExperiment} object.}

\item{matrix}{Character, must be one of \code{"count"}, \code{"normalized"}, or \code{"scaled"}.}

\item{max.cor}{Numeric, correlation coefficients bigger than \code{max.cor} are set to \code{max.cor}. It is used to clearly show small correlation coefficients.}

\item{cor.method}{Character, the method to calculate correlation coefficients. must be one of \code{"pearson"}, \code{"kendall"}, or \code{"spearman"}.}
}
\value{
A \code{ggplot} object.
}
\description{
Heatmap pf correlation coefficients between any two sections in a \code{SummarizedExperiment} object.
}
\examples{
data(zh.data)
zh <- createTomo(zh.data)
corHeatmap(zh)

# Use Spearman correlation coefficients.
corHeatmap(zh, cor.method='spearman')

# Set max correlation coefficients to 0.3.
corHeatmap(zh, max.cor=0.3)
}
