% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmms.filter.lines.R
\name{lmms.filter.lines}
\alias{lmms.filter.lines}
\title{Filter Linear Profiles from Linear Mixed Model output}
\usage{
lmms.filter.lines(
  data,
  lmms.obj,
  time,
  homoskedasticity = TRUE,
  MSE.filter = TRUE,
  homoskedasticity.cutoff = 0.05
)
}
\arguments{
\item{data}{a data.frame used in the \code{lmms::lmmSpline} command}

\item{lmms.obj}{a \code{lmmspline} object}

\item{time}{a numeric vector containing the sample time point information.}

\item{homoskedasticity}{a logical whether or not to test for homoscedasticity with the Breusch-Pagan test.}

\item{MSE.filter}{whether or not to test for low dispersion with a cutoff on the MSE.}

\item{homoskedasticity.cutoff}{a numeric scalar between 0 and 1, p-value threshold for B-P test.}
}
\value{
a list containing the following items
\item{filtering.summary}{a data.frame with the different tests per features (passed = TRUE, failed = FALSE)}
\item{to.keep}{features which passed all the tests}
\item{filtered}{the filtered data.frame}
}
\description{
This function filters linear models with highly heterogeneous variability within residues.
From an "lmms" output, 2 parameters are tested:
}
\details{
* homo-sedasticity of the residues with a Breusch-Pagan test 
* low dispersion with a cutoff on the MSE (mean squared error)
}
\examples{
# data and lmms output
data(timeOmics.simdata)
data <- timeOmics.simdata$sim
lmms.output <- timeOmics.simdata$lmms.output
time <- timeOmics.simdata$time

# filter
filter.res <- lmms.filter.lines(data = data, lmms.obj = lmms.output, time = time)


}
\seealso{
\code{\link[lmtest]{bptest}}
}
