% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_normality_check.R
\name{run_normality_check}
\alias{run_normality_check}
\title{Assess Normality of Exposure Variables}
\usage{
run_normality_check(exposomicset, action = "add")
}
\arguments{
\item{exposomicset}{A \code{MultiAssayExperiment} object containing exposure
data in \code{colData}.}

\item{action}{A character string specifying whether to store (\code{"add"})
or return (\code{"get"}) the results. Default is \code{"add"}.}
}
\value{
A \code{MultiAssayExperiment} object with normality results added to
metadata (if \code{action = "add"}) or a list with:
\item{norm_df}{A data frame of Shapiro-Wilk test results for each
exposure variable.}
\item{norm_plot}{A ggplot object showing the distribution of normal
and non-normal exposures.}
}
\description{
Performs Shapiro-Wilk tests to check the normality of numeric exposure
variables in \code{colData} of a \code{MultiAssayExperiment} object.
}
\details{
This function:
\itemize{
\item Extracts \strong{numeric, non-constant} exposure variables from \code{colData}.
\item Runs \strong{Shapiro-Wilk tests} to assess normality.
\item Summarizes the number of normally and non-normally distributed exposures.
\item Generates a bar plot visualizing the normality results.
\item \strong{Output Handling}:
\itemize{
\item \code{"add"}: Stores results in \code{metadata(exposomicset)$normality}.
\item \code{"get"}: Returns a list containing the normality test results and plot.
}
}
}
\examples{
# Create example data
mae <- make_example_data(
    n_samples = 20,
    return_mae = TRUE
)

# Test for normality
mae <- mae |>
    run_normality_check() |>
    transform_exposure(exposure_cols = c("age", "bmi", "exposure_pm25"))

}
